/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client;

import bagu_chan.bagus_lib.client.layer.IArmor;
import bagu_chan.bagus_lib.entity.MiniBagu;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MiniBaguModel<T extends MiniBagu>
extends HierarchicalModel<T>
implements IArmor {
    private final ModelPart root;
    private final ModelPart head;

    public MiniBaguModel(ModelPart root) {
        this.root = root.getChild("root");
        this.head = this.root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = head.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(24, 0).addBox(-2.0f, -3.0f, 0.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.4f * limbSwingAmount;
    }

    public ModelPart root() {
        return this.root;
    }

    @Override
    public void translateToHead(ModelPart part, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        part.translateAndRotate(poseStack);
    }

    @Override
    public void translateToChest(ModelPart part, PoseStack poseStack) {
    }

    @Override
    public void translateToLeg(ModelPart part, PoseStack poseStack) {
    }

    @Override
    public void translateToChestPat(ModelPart part, PoseStack poseStack) {
    }

    @Override
    public Iterable<ModelPart> rightHandArmors() {
        return null;
    }

    @Override
    public Iterable<ModelPart> leftHandArmors() {
        return null;
    }

    @Override
    public Iterable<ModelPart> rightLegPartArmors() {
        return null;
    }

    @Override
    public Iterable<ModelPart> leftLegPartArmors() {
        return null;
    }

    @Override
    public Iterable<ModelPart> bodyPartArmors() {
        return null;
    }

    @Override
    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

