/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.dialog;

import bagu_chan.bagus_lib.client.dialog.DialogOption;
import bagu_chan.bagus_lib.client.dialog.DialogType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class ItemDialogType
extends DialogType {
    public static final MapCodec<ItemDialogType> CODEC = RecordCodecBuilder.mapCodec(p_345644_ -> p_345644_.group((App)Codec.STRING.fieldOf("dialog").forGetter(DialogType::getDialogueBase), (App)DialogOption.CODEC.fieldOf("dialog_option").orElse((Object)new DialogOption(1.0f, 1.0f, true, Optional.empty())).forGetter(DialogType::getDialogueOption), (App)Codec.LONG.fieldOf("dialog_render_time").forGetter(DialogType::getDialogRenderTime), (App)Codec.DOUBLE.fieldOf("draw_per_tick").forGetter(DialogType::getDialogPerTick), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("item").forGetter(ItemDialogType::getItemStack)).apply((Applicative)p_345644_, ItemDialogType::new));
    protected final ItemStack itemStack;

    public ItemDialogType(String dialogueBase, DialogOption dialogueOption, long dialogRenderTime, double dialogPerTick, ItemStack itemStack) {
        super(dialogueBase, dialogueOption, dialogRenderTime, dialogPerTick);
        this.itemStack = itemStack;
    }

    @Override
    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount, int y) {
        if (this.itemStack != null) {
            poseStack.pushPose();
            poseStack.translate(0.0f, (float)y, 0.0f);
            poseStack.scale(this.dialogueOption.scaleX(), this.dialogueOption.scaleY(), 1.0f);
            guiGraphics.renderItem(this.itemStack, 0, 0);
            poseStack.popPose();
        }
    }

    public MapCodec<ItemDialogType> codec() {
        return CODEC;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

