/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.game;

import bagu_chan.bagus_lib.client.game.Fruit;
import bagu_chan.bagus_lib.client.game.FruitObject;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.commons.compress.utils.Lists;
import org.joml.Quaternionf;
import org.joml.Vector2f;

public class WaterMelonCraft {
    static WaterMelonCraft instance;
    protected final RandomSource random = RandomSource.create();
    private int score;
    private float fallingX;
    private int finishTime = 0;
    private int keyCooldown;
    private static int HEIGHT;
    private static int WIDTH;
    private FruitObject tossFruit;
    private final List<FruitObject> fruitObjects = Lists.newArrayList();
    private boolean gameOver = false;
    private FruitObject nextFruit;

    public WaterMelonCraft() {
        instance = this;
        this.reset();
    }

    public void tick(Screen screen) {
        if (this.keyCooldown > 0) {
            --this.keyCooldown;
        }
        if (!this.gameOver) {
            if (this.tossFruit == null) {
                this.generateFruit();
                this.generateNextFruit();
            } else {
                float f = 0.15f;
                if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)264)) {
                    f = 1.0f;
                }
                if (this.keyPressed(263)) {
                    this.fallingX = this.restrictX(screen, this.fallingX - 0.5f);
                }
                if (this.keyPressed(262)) {
                    this.fallingX = this.restrictX(screen, this.fallingX + 0.5f);
                }
                if (this.keyPressed(264)) {
                    FruitObject fruitObject = new FruitObject(this.tossFruit.getFruit());
                    fruitObject.setPos(new Vector2f(this.fallingX, 1.0f));
                    this.fruitObjects.add(fruitObject);
                    this.tossFruit = null;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)1.0f, (float)0.7f));
                }
            }
            boolean flag = false;
            boolean flag2 = false;
            Set<FruitObject> fruitObjects1 = Set.copyOf(this.fruitObjects);
            Set<FruitObject> fruitObjects2 = Set.copyOf(this.fruitObjects);
            for (FruitObject fruitObject : fruitObjects1) {
                for (FruitObject fruitObject2 : fruitObjects2) {
                    if (fruitObject == fruitObject2) continue;
                    int i = fruitObject.collisionAndBig(fruitObject2, this.fruitObjects);
                    fruitObject.collisionBox(fruitObject2);
                    if (i <= 0) continue;
                    flag2 = true;
                    this.score += i;
                    break;
                }
                fruitObject.tick();
                if (flag2) break;
                if (!(fruitObject.getPos().y < 0.0f)) continue;
                flag = true;
            }
            if (flag) {
                ++this.finishTime;
                if (this.finishTime >= 60) {
                    this.gameOver = true;
                }
            } else {
                this.finishTime = 0;
            }
        }
        if (this.keyPressed(87)) {
            this.reset();
        }
    }

    public static WaterMelonCraft getInstance() {
        return instance;
    }

    protected Vector2f collide(Vector2f p_20273_) {
        if (p_20273_.x < 0.0f) {
            return new Vector2f(0.0f, p_20273_.y);
        }
        if (p_20273_.x > (float)WIDTH) {
            return new Vector2f((float)WIDTH, p_20273_.y);
        }
        if (p_20273_.y > (float)HEIGHT) {
            return new Vector2f(p_20273_.x, (float)HEIGHT);
        }
        return p_20273_;
    }

    private float restrictX(Screen screen, float xIn) {
        float scale = WIDTH;
        xIn = Mth.clamp((float)xIn, (float)0.0f, (float)scale);
        return xIn;
    }

    private boolean keyPressed(int keyId) {
        if (this.keyCooldown == 0 && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyId)) {
            this.keyCooldown = 4;
            return true;
        }
        return false;
    }

    private void generateNextFruit() {
        this.nextFruit = new FruitObject(Fruit.getRandom(this.random));
    }

    private void generateFruit() {
        this.tossFruit = this.nextFruit;
    }

    private void renderFruit(FruitObject fruit, float x, float y, float scale, float offsetX, float offsetY) {
        this.renderBlockState(fruit.getFruit().getFruitBlock().defaultBlockState(), fruit.getFruit(), offsetX + x * scale, offsetY + y * scale, scale);
    }

    private static Vector2f transform(Vector2f vector2f, float rotation, Vector2f relativeTo) {
        float i = vector2f.x;
        float k = vector2f.y;
        boolean flag = true;
        Quaternionf quaternionf = Axis.XP.rotationDegrees(rotation);
        return flag ? new Vector2f(i, k).add(quaternionf.x, quaternionf.y) : vector2f;
    }

    private void renderBlockState(BlockState state, Fruit fruit, float offsetX, float offsetY, float size) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getBlockRenderer().getBlockModel(state).getParticleIcon(ModelData.EMPTY);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float f = size * fruit.getSize();
        bufferbuilder.addVertex(-f + offsetX, f + offsetY, 80.0f).setUv(sprite.getU0(), sprite.getV1());
        bufferbuilder.addVertex(f + offsetX, f + offsetY, 80.0f).setUv(sprite.getU1(), sprite.getV1());
        bufferbuilder.addVertex(f + offsetX, -f + offsetY, 80.0f).setUv(sprite.getU1(), sprite.getV0());
        bufferbuilder.addVertex(-f + offsetX, -f + offsetY, 80.0f).setUv(sprite.getU0(), sprite.getV0());
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public void render(Screen screen, GuiGraphics gui, float partialTick) {
        float scale = Math.min((float)screen.width / 15.0f, (float)screen.height / (float)HEIGHT);
        float offsetX = (float)screen.width / 2.0f - scale * 5.0f;
        float offsetY = scale * 0.5f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        if (this.tossFruit != null) {
            this.renderFruit(this.tossFruit, this.fallingX, 0.0f, scale, offsetX, offsetY);
        }
        if (this.nextFruit != null) {
            this.renderFruit(this.nextFruit, 0.0f, 0.0f, scale, (float)screen.width * 0.85f, (float)screen.height * 0.4f);
        }
        for (FruitObject fruitObject : this.fruitObjects) {
            this.renderFruit(fruitObject, fruitObject.getPos().x, fruitObject.getPos().y, scale, offsetX, offsetY);
        }
        float hue = 1.0f;
        int color = 0xFFFFFF;
        gui.pose().pushPose();
        gui.pose().scale(2.0f, 2.0f, 2.0f);
        gui.drawCenteredString(Minecraft.getInstance().font, "Score", (int)((float)screen.width * 0.065f), (int)((float)screen.height * 0.175f), color);
        gui.drawCenteredString(Minecraft.getInstance().font, "" + this.score, (int)((float)screen.width * 0.065f), (int)((float)screen.height * 0.175f) + 10, color);
        gui.pose().popPose();
        gui.drawString(Minecraft.getInstance().font, "[LEFT ARROW] move left", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f), color);
        gui.drawString(Minecraft.getInstance().font, "[RIGHT ARROW] move right", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 10, color);
        gui.drawString(Minecraft.getInstance().font, "[DOWN ARROW] drop fruit", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 30, color);
        gui.drawString(Minecraft.getInstance().font, "[W] start over", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 50, color);
        if (this.gameOver) {
            gui.pose().pushPose();
            gui.pose().translate((float)((int)((float)screen.width * 0.5f)), (float)((int)((float)screen.height * 0.5f)), 150.0f);
            gui.pose().scale(3.0f, 3.0f, 3.0f);
            gui.drawCenteredString(Minecraft.getInstance().font, "GAME OVER", 0, 0, color);
            gui.pose().popPose();
        }
        if (this.finishTime > 0) {
            gui.pose().pushPose();
            gui.pose().translate((float)((int)((float)screen.width * 0.5f)), (float)((int)((float)screen.height * 0.5f)), 150.0f);
            gui.pose().scale(2.0f, 2.0f, 2.0f);
            gui.drawCenteredString(Minecraft.getInstance().font, "" + this.finishTime / 20, 0, 0, color);
            gui.pose().popPose();
        }
    }

    public void reset() {
        this.score = 0;
        this.fruitObjects.removeAll(this.fruitObjects);
        this.gameOver = false;
        this.generateNextFruit();
        this.generateFruit();
        this.generateNextFruit();
    }

    static {
        HEIGHT = 7;
        WIDTH = 5;
    }
}

