/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.new_shield_variants.core.common.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;

public class DragonHeadShieldItem
extends ShieldItem {
    public DragonHeadShieldItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        List list = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(4.0, 2.0, 4.0));
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(player.level(), player.xOld, player.yOld, player.zOld);
        areaeffectcloud.setOwner((LivingEntity)player);
        areaeffectcloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
        areaeffectcloud.setRadius(3.0f);
        areaeffectcloud.setDuration(100);
        areaeffectcloud.setRadiusPerTick((7.0f - areaeffectcloud.getRadius()) / (float)areaeffectcloud.getDuration());
        areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 5));
        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 50, 2));
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = player.distanceToSqr((Entity)livingentity);
                if (!(d0 < 16.0)) continue;
                areaeffectcloud.setPos(livingentity.getX(), livingentity.getY(), livingentity.getZ());
                break;
            }
        }
        player.level().levelEvent(2006, player.blockPosition(), player.isSilent() ? -1 : 1);
        player.level().addFreshEntity((Entity)areaeffectcloud);
        player.getCooldowns().addCooldown((Item)this, 100);
        return InteractionResultHolder.consume((Object)itemstack);
    }
}

