/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.event;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.FoodValues;

@EventBusSubscriber(modid="farmersdelight", value={Dist.CLIENT})
public class TooltipEvents {
    @SubscribeEvent
    public static void addTooltipToVanillaSoups(ItemTooltipEvent event) {
        if (!((Boolean)Configuration.VANILLA_SOUP_EXTRA_EFFECTS.get()).booleanValue()) {
            return;
        }
        Item food = event.getItemStack().getItem();
        FoodProperties soupEffects = FoodValues.VANILLA_SOUP_EFFECTS.get(food);
        if (soupEffects != null) {
            List tooltip = event.getToolTip();
            for (FoodProperties.PossibleEffect effect : soupEffects.effects()) {
                MobEffectInstance effectInstance = effect.effect();
                MutableComponent effectText = Component.translatable((String)effectInstance.getDescriptionId());
                Player player = event.getEntity();
                if (effectInstance.getDuration() > 20) {
                    effectText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{effectText, MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)(player == null ? 20.0f : player.level().tickRateManager().tickrate()))});
                }
                tooltip.add(effectText.withStyle(((MobEffect)effectInstance.getEffect().value()).getCategory().getTooltipFormatting()));
            }
        }
    }
}

