/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.recipe;

import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import vectorwing.farmersdelight.common.crafting.ingredient.ItemAbilityIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class CuttingRecipes {
    public static void register(RecipeOutput output) {
        CuttingRecipes.cuttingAnimalItems(output);
        CuttingRecipes.cuttingVegetables(output);
        CuttingRecipes.cuttingFoods(output);
        CuttingRecipes.cuttingFlowers(output);
        CuttingRecipes.salvagingMinerals(output);
        CuttingRecipes.strippingWood(output);
        CuttingRecipes.salvagingWoodenFurniture(output);
        CuttingRecipes.diggingSediments(output);
        CuttingRecipes.salvagingUsingShears(output);
    }

    private static void cuttingAnimalItems(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEF}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.MINCED_BEEF.get(), 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.BACON.get(), 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.CHICKEN}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.CHICKEN_CUTS.get(), 2).addResult((ItemLike)Items.BONE_MEAL).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKED_CHICKEN}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.COOKED_CHICKEN_CUTS.get(), 2).addResult((ItemLike)Items.BONE_MEAL).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.COD}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.COD_SLICE.get(), 2).addResult((ItemLike)Items.BONE_MEAL).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKED_COD}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.COOKED_COD_SLICE.get(), 2).addResult((ItemLike)Items.BONE_MEAL).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.SALMON}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.SALMON_SLICE.get(), 2).addResult((ItemLike)Items.BONE_MEAL).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKED_SALMON}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.COOKED_SALMON_SLICE.get(), 2).addResult((ItemLike)Items.BONE_MEAL).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAM.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.PORKCHOP, 2).addResult((ItemLike)Items.BONE).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SMOKED_HAM.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.COOKED_PORKCHOP, 2).addResult((ItemLike)Items.BONE).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.MUTTON}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.MUTTON_CHOPS.get(), 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKED_MUTTON}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.COOKED_MUTTON_CHOPS.get(), 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.INK_SAC}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.BLACK_DYE, 2).build(output);
    }

    private static void cuttingVegetables(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.CABBAGE_LEAF.get(), 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE_PANICLE.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.RICE.get(), 1).addResult((ItemLike)ModItems.STRAW.get()).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.MELON_SLICE, 9).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.PUMPKIN_SLICE.get(), 4).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BROWN_MUSHROOM_COLONY.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.BROWN_MUSHROOM, 5).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RED_MUSHROOM_COLONY.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.RED_MUSHROOM, 5).build(output);
    }

    private static void cuttingFoods(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of(CommonTags.FOODS_DOUGH), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.RAW_PASTA.get(), 1).build(output, ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"tag_dough"));
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.KELP_ROLL.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.KELP_ROLL_SLICE.get(), 3).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.CAKE}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.CAKE_SLICE.get(), 7).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.APPLE_PIE.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.APPLE_PIE_SLICE.get(), 4).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SWEET_BERRY_CHEESECAKE.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.SWEET_BERRY_CHEESECAKE_SLICE.get(), 4).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHOCOLATE_PIE.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.CHOCOLATE_PIE_SLICE.get(), 4).build(output);
    }

    private static void cuttingFlowers(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.WITHER_ROSE}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.BLACK_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.CORNFLOWER}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.BLUE_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_ORCHID}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.LIGHT_BLUE_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.AZURE_BLUET}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.LIGHT_GRAY_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.OXEYE_DAISY}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.LIGHT_GRAY_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_TULIP}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.LIGHT_GRAY_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.ALLIUM}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.MAGENTA_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_TULIP}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.ORANGE_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_TULIP}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.PINK_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_TULIP}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.RED_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPY}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.RED_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.LILY_OF_THE_VALLEY}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.WHITE_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.DANDELION}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.YELLOW_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCHFLOWER}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.ORANGE_DYE, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_BEETROOTS.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.BEETROOT_SEEDS, 1).addResult((ItemLike)Items.RED_DYE).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_CABBAGES.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.CABBAGE_SEEDS.get(), 1).addResultWithChance((ItemLike)Items.YELLOW_DYE, 0.5f, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_CARROTS.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.CARROT, 1).addResultWithChance((ItemLike)Items.LIGHT_GRAY_DYE, 0.5f, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_ONIONS.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.ONION.get(), 1).addResult((ItemLike)Items.MAGENTA_DYE, 2).addResultWithChance((ItemLike)Items.LIME_DYE, 0.1f).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_POTATOES.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)Items.POTATO, 1).addResultWithChance((ItemLike)Items.PURPLE_DYE, 0.5f, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_RICE.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.RICE.get(), 1).addResultWithChance((ItemLike)ModItems.STRAW.get(), 0.5f).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_TOMATOES.get()}), Ingredient.of(CommonTags.TOOLS_KNIFE), (ItemLike)ModItems.TOMATO_SEEDS.get(), 1).addResultWithChance((ItemLike)ModItems.TOMATO.get(), 0.2f).addResultWithChance((ItemLike)Items.GREEN_DYE, 0.1f).build(output);
    }

    private static void salvagingMinerals(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BRICKS}), new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)Items.BRICK, 4).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_BRICKS}), new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)Items.NETHER_BRICK, 4).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)Items.COBBLESTONE, 1).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE}), new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)Items.COBBLED_DEEPSLATE, 1).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)Items.QUARTZ, 4).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK}), new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)Items.AMETHYST_SHARD, 4).build(output);
    }

    private static void strippingWood(RecipeOutput output) {
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.OAK_LOG, (ItemLike)Items.STRIPPED_OAK_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.OAK_WOOD, (ItemLike)Items.STRIPPED_OAK_WOOD);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.SPRUCE_LOG, (ItemLike)Items.STRIPPED_SPRUCE_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.SPRUCE_WOOD, (ItemLike)Items.STRIPPED_SPRUCE_WOOD);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.BIRCH_LOG, (ItemLike)Items.STRIPPED_BIRCH_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.BIRCH_WOOD, (ItemLike)Items.STRIPPED_BIRCH_WOOD);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.JUNGLE_LOG, (ItemLike)Items.STRIPPED_JUNGLE_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.JUNGLE_WOOD, (ItemLike)Items.STRIPPED_JUNGLE_WOOD);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.ACACIA_LOG, (ItemLike)Items.STRIPPED_ACACIA_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.ACACIA_WOOD, (ItemLike)Items.STRIPPED_ACACIA_WOOD);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.DARK_OAK_LOG, (ItemLike)Items.STRIPPED_DARK_OAK_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.DARK_OAK_WOOD, (ItemLike)Items.STRIPPED_DARK_OAK_WOOD);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.MANGROVE_LOG, (ItemLike)Items.STRIPPED_MANGROVE_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.MANGROVE_WOOD, (ItemLike)Items.STRIPPED_MANGROVE_WOOD);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.CHERRY_LOG, (ItemLike)Items.STRIPPED_CHERRY_LOG);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.CHERRY_WOOD, (ItemLike)Items.STRIPPED_CHERRY_WOOD);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_BLOCK}), new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), (ItemLike)Items.STRIPPED_BAMBOO_BLOCK).addResult((ItemLike)ModItems.STRAW.get()).addSound(SoundEvents.AXE_STRIP).build(output);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.CRIMSON_STEM, (ItemLike)Items.STRIPPED_CRIMSON_STEM);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.CRIMSON_HYPHAE, (ItemLike)Items.STRIPPED_CRIMSON_HYPHAE);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.WARPED_STEM, (ItemLike)Items.STRIPPED_WARPED_STEM);
        CuttingRecipes.stripLogForBark(output, (ItemLike)Items.WARPED_HYPHAE, (ItemLike)Items.STRIPPED_WARPED_HYPHAE);
    }

    private static void salvagingWoodenFurniture(RecipeOutput output) {
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.OAK_PLANKS, (ItemLike)Items.OAK_DOOR, (ItemLike)Items.OAK_TRAPDOOR, (ItemLike)Items.OAK_SIGN, (ItemLike)Items.OAK_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.SPRUCE_PLANKS, (ItemLike)Items.SPRUCE_DOOR, (ItemLike)Items.SPRUCE_TRAPDOOR, (ItemLike)Items.SPRUCE_SIGN, (ItemLike)Items.SPRUCE_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.BIRCH_PLANKS, (ItemLike)Items.BIRCH_DOOR, (ItemLike)Items.BIRCH_TRAPDOOR, (ItemLike)Items.BIRCH_SIGN, (ItemLike)Items.BIRCH_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.JUNGLE_PLANKS, (ItemLike)Items.JUNGLE_DOOR, (ItemLike)Items.JUNGLE_TRAPDOOR, (ItemLike)Items.JUNGLE_SIGN, (ItemLike)Items.JUNGLE_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.ACACIA_PLANKS, (ItemLike)Items.ACACIA_DOOR, (ItemLike)Items.ACACIA_TRAPDOOR, (ItemLike)Items.ACACIA_SIGN, (ItemLike)Items.ACACIA_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.DARK_OAK_PLANKS, (ItemLike)Items.DARK_OAK_DOOR, (ItemLike)Items.DARK_OAK_TRAPDOOR, (ItemLike)Items.DARK_OAK_SIGN, (ItemLike)Items.DARK_OAK_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.MANGROVE_PLANKS, (ItemLike)Items.MANGROVE_DOOR, (ItemLike)Items.MANGROVE_TRAPDOOR, (ItemLike)Items.MANGROVE_SIGN, (ItemLike)Items.MANGROVE_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.CHERRY_PLANKS, (ItemLike)Items.CHERRY_DOOR, (ItemLike)Items.CHERRY_TRAPDOOR, (ItemLike)Items.CHERRY_SIGN, (ItemLike)Items.CHERRY_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.BAMBOO_PLANKS, (ItemLike)Items.BAMBOO_DOOR, (ItemLike)Items.BAMBOO_TRAPDOOR, (ItemLike)Items.BAMBOO_SIGN, (ItemLike)Items.BAMBOO_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.CRIMSON_PLANKS, (ItemLike)Items.CRIMSON_DOOR, (ItemLike)Items.CRIMSON_TRAPDOOR, (ItemLike)Items.CRIMSON_SIGN, (ItemLike)Items.CRIMSON_HANGING_SIGN);
        CuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)Items.WARPED_PLANKS, (ItemLike)Items.WARPED_DOOR, (ItemLike)Items.WARPED_TRAPDOOR, (ItemLike)Items.WARPED_SIGN, (ItemLike)Items.WARPED_HANGING_SIGN);
    }

    private static void diggingSediments(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY}), new ItemAbilityIngredient(ItemAbilities.SHOVEL_DIG).toVanilla(), (ItemLike)Items.CLAY_BALL, 4).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL}), new ItemAbilityIngredient(ItemAbilities.SHOVEL_DIG).toVanilla(), (ItemLike)Items.GRAVEL, 1).addResultWithChance((ItemLike)Items.FLINT, 0.1f).build(output);
    }

    private static void salvagingUsingShears(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.SADDLE}), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.LEATHER, 2).addResultWithChance((ItemLike)Items.IRON_NUGGET, 0.5f, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_HORSE_ARMOR}), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.LEATHER, 2).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_HELMET}), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.LEATHER, 1).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_CHESTPLATE}), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.LEATHER, 1).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_LEGGINGS}), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.LEATHER, 1).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_BOOTS}), Ingredient.of((TagKey)Tags.Items.TOOLS_SHEAR), (ItemLike)Items.LEATHER, 1).build(output);
    }

    private static void salvagePlankFromFurniture(RecipeOutput output, ItemLike plank, ItemLike door, ItemLike trapdoor, ItemLike sign, ItemLike hangingSign) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{door}), new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), plank).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{trapdoor}), new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), plank).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{sign}), new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), plank).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{hangingSign}), new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), plank).build(output);
    }

    private static void stripLogForBark(RecipeOutput output, ItemLike log, ItemLike strippedLog) {
        CuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{log}), new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), strippedLog).addResult((ItemLike)ModItems.TREE_BARK.get()).addSound(SoundEvents.AXE_STRIP).build(output);
    }
}

