/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.otherside;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.world.DDCarvers;
import com.kyanite.deeperdarker.world.DDPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OthersideBiomes {
    public static final ResourceKey<Biome> DEEPLANDS = OthersideBiomes.createKey("deeplands");
    public static final ResourceKey<Biome> ECHOING_FOREST = OthersideBiomes.createKey("echoing_forest");
    public static final ResourceKey<Biome> BLOOMING_CAVERNS = OthersideBiomes.createKey("blooming_caverns");
    public static final ResourceKey<Biome> OVERCAST_COLUMNS = OthersideBiomes.createKey("overcast_columns");

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter worldCarvers = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(DEEPLANDS, (Object)OthersideBiomes.deeplands((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(ECHOING_FOREST, (Object)OthersideBiomes.echoingForest((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(BLOOMING_CAVERNS, (Object)OthersideBiomes.bloomingCaverns((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.register(OVERCAST_COLUMNS, (Object)OthersideBiomes.overcastColumns((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
    }

    public static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)DeeperDarker.rl(name));
    }

    private static Biome deeplands(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_CENTIPEDE.get(), 6, 1, 4));
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_SNAPPER.get(), 11, 3, 6));
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SHATTERED.get(), 5, 2, 4));
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.PHANTOM, 2, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeBuilder.addCarver(GenerationStep.Carving.AIR, DDCarvers.CAVE);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.SCULK_STONE_COLUMN);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.SCULK_GLEAM);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SURFACE_SCULK_STONE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SCULK_DECORATION);
        OthersideBiomes.addSculkDecoration(biomeBuilder);
        OthersideBiomes.addSculkOres(biomeBuilder);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(-0.5f).downfall(-0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(1254763).waterFogColor(1253458).fogColor(1317939).skyColor(OthersideBiomes.calculateSkyColor(-0.5f)).ambientMoodSound(new AmbientMoodSettings(DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.getDelegate(), 6000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)DDSounds.MUSIC_BIOME_DEEPLANDS.getDelegate())).build()).mobSpawnSettings(mobSpawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    private static Biome echoingForest(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_SNAPPER.get(), 9, 1, 2));
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SHATTERED.get(), 17, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeBuilder.addCarver(GenerationStep.Carving.AIR, DDCarvers.CAVE);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.SCULK_GLEAM_FOREST);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.ECHO_TREE);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.ECHO_SOIL);
        OthersideBiomes.addSculkDecoration(biomeBuilder);
        OthersideBiomes.addSculkOres(biomeBuilder);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.3f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4330347).waterFogColor(3742046).fogColor(3152448).skyColor(OthersideBiomes.calculateSkyColor(0.3f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.ASH, 0.04f)).ambientMoodSound(new AmbientMoodSettings(DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.getDelegate(), 6000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)DDSounds.MUSIC_BIOME_ECHOING_FOREST.getDelegate())).build()).mobSpawnSettings(mobSpawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    private static Biome bloomingCaverns(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.ANGLER_FISH.get(), 6, 3, 5));
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_SNAPPER.get(), 1, 1, 2));
        mobSpawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SLUDGE.get(), 6, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeBuilder.addCarver(GenerationStep.Carving.AIR, DDCarvers.CAVE);
        biomeBuilder.addFeature(GenerationStep.Decoration.LAKES, DDPlacedFeatures.BLOOMING_WATER_EDGE);
        biomeBuilder.addFeature(GenerationStep.Decoration.LAKES, DDPlacedFeatures.BLOOMING_POOL);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.BLOOMING_SCULK_VEGETATION);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.BLOOMING_MOSS);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.BLOOMING_PLANT);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.GLOWING_ROOTS);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.GLOWING_VINES);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.GLOWING_VINES_SHORT);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SCULK_VINES_CAVERNS);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.ICE_LILY);
        OthersideBiomes.addSculkOres(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(-0.3f).downfall(0.2f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(2601177).waterFogColor(2189448).fogColor(1716032).skyColor(OthersideBiomes.calculateSkyColor(-0.3f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, 0.002f)).ambientMoodSound(new AmbientMoodSettings(DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.getDelegate(), 6000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)DDSounds.MUSIC_BIOME_ECHOING_FOREST.getDelegate())).build()).mobSpawnSettings(mobSpawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    private static Biome overcastColumns(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeBuilder.addCarver(GenerationStep.Carving.AIR, DDCarvers.CAVE);
        biomeBuilder.addCarver(GenerationStep.Carving.AIR, DDCarvers.LOW_CAVE);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.GLOOMSLATE_COLUMN);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SURFACE_GLOOMSLATE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.GLOOMY_SCULK_VEGETATION);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMY_SCULK);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.MAGMA);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SOUL_SAND);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SOUL_SOIL);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_COAL);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_IRON);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_COPPER);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_GOLD);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_REDSTONE);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_EMERALD);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_LAPIS);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_DIAMOND);
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.2f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4530962).waterFogColor(3547929).fogColor(4663576).skyColor(OthersideBiomes.calculateSkyColor(0.6f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SMOKE, 0.026f)).ambientMoodSound(new AmbientMoodSettings(DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.getDelegate(), 6000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)DDSounds.MUSIC_BIOME_OVERCAST_COLUMNS.getDelegate())).build()).mobSpawnSettings(MobSpawnSettings.EMPTY).generationSettings(biomeBuilder.build()).build();
    }

    public static void addSculkDecoration(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SCULK_TENDRILS);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SCULK_VINES);
    }

    public static void addSculkOres(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.INFESTED_SCULK);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_JAW);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_COAL);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_IRON);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_COPPER);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_GOLD);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_REDSTONE);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_EMERALD);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_LAPIS);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_DIAMOND);
    }

    private static int calculateSkyColor(float temp) {
        float s = temp / 3.0f;
        s = Mth.clamp((float)s, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - s * 0.05f), (float)(0.5f + s * 0.1f), (float)1.0f);
    }
}

