/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_useful_copper.core.entity;

import java.util.UUID;
import neoforge.com.cursee.more_useful_copper.core.entity.goal.CopperGolemAttackGoal;
import neoforge.com.cursee.more_useful_copper.core.entity.goal.DefendPlayerTargetGoal;
import neoforge.com.cursee.more_useful_copper.core.entity.goal.FollowPlayerGoal;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CopperGolem
extends PathfinderMob
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int attackAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();

    public CopperGolem(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 15.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
        super.defineSynchedData($$0);
        $$0.define(ATTACKING, (Object)false);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CopperGolemAttackGoal(this, 1.05, true));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 16.0f));
        this.goalSelector.addGoal(3, (Goal)new FollowPlayerGoal(this, 1.05));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new DefendPlayerTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Monster.class}));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, livingEntity -> livingEntity instanceof Enemy && !(livingEntity instanceof Creeper)));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    private void setupAnimationStates() {
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.start(this.tickCount);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.stop();
        }
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID persistentAngerTarget) {
    }

    public void startPersistentAngerTimer() {
    }
}

