/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_useful_copper.mixin;

import java.util.function.Predicate;
import neoforge.com.cursee.more_useful_copper.core.entity.CopperGolem;
import neoforge.com.cursee.more_useful_copper.core.registry.ModEntityTypesNeoForge;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CarvedPumpkinBlock.class})
public class NeoForgeCarvedPumpkinBlockMixin {
    @Unique
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = state -> state != null && (state.is(Blocks.CARVED_PUMPKIN) || state.is(Blocks.JACK_O_LANTERN));
    @Unique
    @Nullable
    private BlockPattern unique_$_golemPattern;

    @Inject(method={"trySpawnGolem"}, at={@At(value="HEAD")})
    private void injected_$_onTrySpawnGolem(Level level, BlockPos blockPos, CallbackInfo ci) {
        CopperGolem golem;
        BlockPattern.BlockPatternMatch blocksInPattern = this.unique_$_getOrCreateGolemPattern().find((LevelReader)level, blockPos);
        if (blocksInPattern != null && (golem = (CopperGolem)((EntityType)ModEntityTypesNeoForge.COPPER_GOLEM.get()).create(level)) != null) {
            NeoForgeCarvedPumpkinBlockMixin.unique_$_clearPatternAndSpawnEntity(level, blocksInPattern, (Entity)golem, blocksInPattern.getBlock(1, 2, 0).getPos());
        }
    }

    @Unique
    private BlockPattern unique_$_getOrCreateGolemPattern() {
        if (this.unique_$_golemPattern == null) {
            this.unique_$_golemPattern = BlockPatternBuilder.start().aisle(new String[]{"~^~", "###", "~#~"}).where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.COPPER_BLOCK))).where('~', p_284868_ -> p_284868_.getState().isAir()).build();
        }
        return this.unique_$_golemPattern;
    }

    @Unique
    private static void unique_$_clearPatternAndSpawnEntity(Level level, BlockPattern.BlockPatternMatch blockPatternMatch, Entity entity, BlockPos blockPos) {
        CarvedPumpkinBlock.clearPatternBlocks((Level)level, (BlockPattern.BlockPatternMatch)blockPatternMatch);
        entity.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.05, (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity(entity);
        for (ServerPlayer $$4 : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger($$4, entity);
        }
        CarvedPumpkinBlock.updatePatternBlocks((Level)level, (BlockPattern.BlockPatternMatch)blockPatternMatch);
    }
}

