/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.crafttweaker.handlers;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@IRecipeHandler.For(value=WorkbenchContructingRecipe.class)
public class WorkbenchConstructingRecipeHandler
implements IRecipeHandler<WorkbenchContructingRecipe> {
    public String dumpToCommandString(IRecipeManager<? super WorkbenchContructingRecipe> manager, RegistryAccess registryAccess, RecipeHolder<WorkbenchContructingRecipe> holder) {
        return String.format("%s.addRecipe(%s, %s, %s);", manager.getCommandString(), StringUtil.quoteAndEscape((ResourceLocation)holder.id()), IItemStack.ofMutable((ItemStack)((WorkbenchContructingRecipe)holder.value()).getResult()).getCommandString(), "[" + String.join((CharSequence)", ", (CharSequence[])((WorkbenchContructingRecipe)holder.value()).getMaterials().stream().map(v -> IIngredient.fromIngredient((Ingredient)v.ingredient()).mul(v.count()).getCommandString()).toArray(String[]::new)) + "]");
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super WorkbenchContructingRecipe> manager, WorkbenchContructingRecipe firstRecipe, U secondRecipe) {
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super WorkbenchContructingRecipe> manager, RegistryAccess registryAccess, WorkbenchContructingRecipe recipe) {
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, recipe.getMaterials().stream().map(stack -> IIngredient.fromIngredient((Ingredient)stack.ingredient()).mul(stack.count())).map(v -> (IIngredient)v).collect(Collectors.toList())).with(BuiltinRecipeComponents.Output.ITEMS, (Object)IItemStack.ofMutable((ItemStack)recipe.getResult())).build();
        return Optional.of(decomposedRecipe);
    }

    public Optional<WorkbenchContructingRecipe> recompose(IRecipeManager<? super WorkbenchContructingRecipe> manager, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        NonNullList materials = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS).stream().map(IIngredient::asIIngredientWithAmount).map(v -> StackedIngredient.of(v.ingredient().asVanillaIngredient(), v.amount())).collect(NonNullList::create, AbstractList::add, AbstractCollection::addAll);
        ItemStack result = ((IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS)).getInternal();
        return Optional.of(new WorkbenchContructingRecipe((NonNullList<StackedIngredient>)materials, result, false));
    }
}

