/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.framework.api.menu.IMenuData;
import com.mrcrayfish.furniture.refurbished.blockentity.IWorkbench;
import com.mrcrayfish.furniture.refurbished.client.ClientWorkbench;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleContainerMenu;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WorkbenchMenu
extends SimpleContainerMenu
implements IElectricityMenu {
    private final IWorkbench workbench;
    private final Level level;
    private final ContainerLevelAccess access;
    private final ContainerData data;
    private final DataSlot selectedRecipe;
    private final DataSlot searchNeighbours;
    private final List<RecipeHolder<WorkbenchContructingRecipe>> recipes;
    private final Map<ResourceLocation, Boolean> recipeToCraftable = new HashMap<ResourceLocation, Boolean>();
    private final ResultContainer result = new ResultContainer();
    private final Slot resultSlot;
    private Map<Integer, Integer> counts = new Int2IntOpenHashMap();
    private long lastSoundTime;
    @Nullable
    private Runnable updateCallback;

    public WorkbenchMenu(int windowId, Inventory playerInventory, CustomData data) {
        this(windowId, playerInventory, new ClientWorkbench((Container)new SimpleContainer(12)), (ContainerData)new SimpleContainerData(1));
        this.selectedRecipe.set(data.selectedRecipe());
        this.searchNeighbours.set(data.searchNeighbours());
        this.data.set(0, data.powered());
    }

    public WorkbenchMenu(int windowId, Inventory playerInventory, IWorkbench workbench, ContainerData data) {
        super((MenuType)ModMenuTypes.WORKBENCH.get(), windowId, workbench.getWorkbenchContainer());
        WorkbenchMenu.checkContainerSize((Container)workbench.getWorkbenchContainer(), (int)12);
        WorkbenchMenu.checkContainerDataCount((ContainerData)data, (int)1);
        workbench.getWorkbenchContainer().startOpen(playerInventory.player);
        this.workbench = workbench;
        this.level = playerInventory.player.level();
        this.access = workbench.createLevelAccess();
        this.data = data;
        this.selectedRecipe = workbench.selectedRecipeDataSlot();
        this.searchNeighbours = workbench.searchNeighboursDataSlot();
        this.recipes = this.setupRecipes(this.level);
        this.addContainerSlots(8, 18, 2, 6, 0);
        this.resultSlot = this.addSlot(new WorkbenchResultSlot((Container)this.result, 0, 188, 21));
        this.addPlayerInventorySlots(28, 147, playerInventory);
        this.addDataSlot(this.selectedRecipe);
        this.addDataSlot(this.searchNeighbours);
        this.addDataSlots(this.data);
    }

    public Level getLevel() {
        return this.level;
    }

    public List<RecipeHolder<WorkbenchContructingRecipe>> getRecipes() {
        return this.recipes;
    }

    private List<RecipeHolder<WorkbenchContructingRecipe>> setupRecipes(Level level) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get()).stream().sorted(Comparator.comparing(holder -> ((WorkbenchContructingRecipe)holder.value()).getResultId())).collect(Collectors.toList());
    }

    private void updateResultSlot() {
        if (!this.level.isClientSide()) {
            int selectedRecipeIndex = this.selectedRecipe.get();
            if (this.isPowered() && selectedRecipeIndex >= 0 && selectedRecipeIndex < this.recipes.size()) {
                RecipeHolder<WorkbenchContructingRecipe> recipe = this.recipes.get(selectedRecipeIndex);
                if (this.workbench.canCraft(recipe)) {
                    ItemStack output;
                    ItemStack result = this.result.getItem(0);
                    if (!ItemStack.matches((ItemStack)result, (ItemStack)(output = ((WorkbenchContructingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess())))) {
                        this.resultSlot.set(output.copy());
                    }
                } else {
                    this.resultSlot.set(ItemStack.EMPTY);
                }
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
            super.broadcastChanges();
        }
    }

    public void broadcastChanges() {
        this.updateResultSlot();
        super.broadcastChanges();
    }

    public boolean clickMenuButton(Player player, int button) {
        if (button >= 0 && button < this.recipes.size()) {
            this.selectedRecipe.set(button);
            this.updateResultSlot();
            return true;
        }
        return false;
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (slotIndex == this.resultSlot.index) {
                Item item = slotStack.getItem();
                item.onCraftedBy(slotStack, player.level(), player);
                if (!this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true) : (slotIndex < this.container.getContainerSize() + 27 ? !this.moveItemStackTo(slotStack, this.container.getContainerSize() + 27, this.slots.size(), false) : !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size() - 9, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            this.broadcastChanges();
        }
        return stack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot != this.resultSlot && super.canTakeItemForPickAll(stack, slot);
    }

    @Override
    public boolean isPowered() {
        return this.data.get(0) != 0;
    }

    @Nullable
    public RecipeHolder<WorkbenchContructingRecipe> getSelectedRecipe() {
        int index = this.selectedRecipe.get();
        return index != -1 ? this.recipes.get(index) : null;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipe.get();
    }

    public boolean shouldSearchNeighbours() {
        return this.searchNeighbours.get() != 0;
    }

    public void toggleSearchNeighbours() {
        this.searchNeighbours.set(this.shouldSearchNeighbours() ? 0 : 1);
        this.broadcastChanges();
    }

    public void updateItemCounts(Map<Integer, Integer> counts) {
        this.counts = counts;
        this.recipeToCraftable.clear();
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    public boolean canCraft(RecipeHolder<WorkbenchContructingRecipe> recipe) {
        return this.isPowered() && this.recipeToCraftable.computeIfAbsent(recipe.id(), id -> {
            HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
            for (StackedIngredient material : ((WorkbenchContructingRecipe)recipe.value()).getMaterials()) {
                if (this.hasMaterials(material, found)) continue;
                return false;
            }
            return true;
        }) != false;
    }

    public boolean hasMaterials(StackedIngredient material, Map<Integer, Integer> counted) {
        int remaining = material.count();
        for (ItemStack stack : material.ingredient().getItems()) {
            int itemId = Item.getId((Item)stack.getItem());
            int count = this.counts.getOrDefault(itemId, 0);
            if ((count -= counted.getOrDefault(itemId, 0).intValue()) <= 0) continue;
            if (count >= remaining) {
                counted.merge(itemId, remaining, Integer::sum);
                remaining = 0;
                break;
            }
            counted.merge(itemId, count, Integer::sum);
            remaining -= count;
        }
        return remaining <= 0;
    }

    public void setUpdateCallback(Runnable callback) {
        this.updateCallback = callback;
    }

    private void onCraft() {
        RecipeHolder<WorkbenchContructingRecipe> recipe = this.getSelectedRecipe();
        if (recipe != null && this.workbench.canCraft(recipe)) {
            this.workbench.performCraft(recipe);
            this.updateResultSlot();
            this.access.execute((level, pos) -> {
                long time = level.getGameTime();
                this.lastSoundTime = time;
                if (this.lastSoundTime != this.lastSoundTime) {
                    level.playSound(null, pos, (SoundEvent)ModSounds.BLOCK_WORKBENCH_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            });
        }
    }

    public record CustomData(int selectedRecipe, int searchNeighbours, int powered) implements IMenuData<CustomData>
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, CustomData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CustomData::selectedRecipe, (StreamCodec)ByteBufCodecs.VAR_INT, CustomData::searchNeighbours, (StreamCodec)ByteBufCodecs.VAR_INT, CustomData::powered, CustomData::new);

        public StreamCodec<RegistryFriendlyByteBuf, CustomData> codec() {
            return STREAM_CODEC;
        }
    }

    private class WorkbenchResultSlot
    extends Slot {
        public WorkbenchResultSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public void onTake(Player player, ItemStack stack) {
            stack.onCraftedBy(player.level(), player, stack.getCount());
            WorkbenchMenu.this.onCraft();
            super.onTake(player, stack);
        }
    }
}

