/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.automessage.core.message;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import neoforge.com.cursee.automessage.Constants;
import neoforge.com.cursee.automessage.core.message.GeneralMSConfig;
import neoforge.com.cursee.automessage.core.message.util.Message;
import neoforge.com.cursee.automessage.core.message.util.MessageSchedule;
import neoforge.com.cursee.automessage.core.message.util.MessageServiceUtil;
import neoforge.com.cursee.automessage.platform.Services;

public class ClientMessageService {
    public static ClientMessageService instance;
    public final Map<MessageSchedule, LinkedList<Message>> MESSAGES_FROM_SCHEDULE_MAP = new HashMap<MessageSchedule, LinkedList<Message>>();
    public final LinkedList<Message> ON_FIRST_JOIN_MESSAGES = new LinkedList();
    public final LinkedList<Message> ON_JOIN_LEVEL_MESSAGES = new LinkedList();
    public final LinkedList<Message> ON_DEATH_MESSAGES = new LinkedList();
    public final LinkedList<Message> ON_RESPAWN_MESSAGES = new LinkedList();
    public final LinkedList<Message> ON_SLEEP_IN_BED_MESSAGES = new LinkedList();
    public final LinkedList<Message> ON_WAKE_UP_MESSAGES = new LinkedList();
    public final LinkedList<Message> OVERWORLD_TO_NETHER_MESSAGES = new LinkedList();
    public final LinkedList<Message> OVERWORLD_TO_END_MESSAGES = new LinkedList();
    public final LinkedList<Message> NETHER_TO_OVERWORLD_MESSAGES = new LinkedList();
    public final LinkedList<Message> END_TO_OVERWORLD_MESSAGES = new LinkedList();
    public GeneralMSConfig general = new GeneralMSConfig();
    public LinkedList<String> message_json_files = new LinkedList();

    public static void load() {
        File configFile;
        long start = System.nanoTime();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String configDirPath = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        File configDir = new File(configDirPath);
        if (!configDir.isDirectory()) {
            configDir.mkdirs();
        }
        if (!(configFile = new File(configDirPath + File.separator + "automessage-client.json")).isFile()) {
            Constants.LOG.info("[CLIENT] No config file found. Creating and reloading.");
            MessageServiceUtil.copyResourceToFile("/assets/automessage/client_default.json", configFile);
            File configMessagesFile = new File(configDirPath + File.separator + "messages" + File.separator + "client_messages.json");
            MessageServiceUtil.copyResourceToFile("/assets/automessage/client_messages.json", configMessagesFile);
            ClientMessageService.load();
            return;
        }
        if (configFile.isFile()) {
            try (FileReader reader = new FileReader(configFile);){
                if (instance == null || !Services.PLATFORM.isClientSide()) {
                    instance = (ClientMessageService)gson.fromJson((Reader)reader, ClientMessageService.class);
                }
                instance.initMaps();
            }
            catch (IOException e) {
                Constants.LOG.info("[CLIENT] Failed to read: {}", (Object)configFile.getName());
                Constants.LOG.info(e.toString());
                Constants.LOG.info("[CLIENT] Using default configuration messages.");
                e.fillInStackTrace();
            }
            if (ClientMessageService.instance.message_json_files == null || ClientMessageService.instance.message_json_files.isEmpty()) {
                Constants.LOG.info("[CLIENT] No message files listed in configuration: {}", (Object)configFile.getName());
                Constants.LOG.info("[CLIENT] Loading fallback configuration messages.");
                MessageServiceUtil.loadFallbackMessages(gson);
                return;
            }
            for (String pattern : ClientMessageService.instance.message_json_files) {
                ArrayList<File> filesToLoad = pattern.contains("*") ? MessageServiceUtil.resolveMessagePaths(pattern) : List.of(new File("config", pattern));
                AtomicInteger atomicInteger = new AtomicInteger(0);
                for (File file : filesToLoad) {
                    if (file.exists()) {
                        try (FileReader msgReader = new FileReader(file);){
                            Type listType = new TypeToken<List<Message>>(){}.getType();
                            List loaded = (List)gson.fromJson((Reader)msgReader, listType);
                            loaded.forEach(message -> {
                                if (message.text.contains("\u00a7")) {
                                    message.text = message.text.replaceAll("\u00a7", "\u00a7");
                                }
                                ClientMessageService.instance.MESSAGES_FROM_SCHEDULE_MAP.get((Object)message.schedule).add((Message)message);
                                atomicInteger.incrementAndGet();
                            });
                        }
                        catch (Exception e) {
                            Constants.LOG.info("[CLIENT] Failed to load message file: {}", (Object)file.getPath());
                            Constants.LOG.info(e.toString());
                            e.fillInStackTrace();
                        }
                        continue;
                    }
                    Constants.LOG.info("[CLIENT] Message file not found: {}", (Object)file.getPath());
                }
                Constants.LOG.info("[CLIENT] MessageService loaded {} messages", (Object)atomicInteger.get());
            }
            List<List<?>> e = instance.allMessageLists();
        }
        long end = System.nanoTime();
        long time = end - start;
        Constants.LOG.info("[CLIENT] MessageService loaded on client in {}ns or {}ms or {}s", new Object[]{time, time / 1000000L, Float.valueOf((float)time / 1.0E9f)});
    }

    public void initMaps() {
        this.MESSAGES_FROM_SCHEDULE_MAP.put(MessageSchedule.ON_FIRST_JOIN, this.ON_FIRST_JOIN_MESSAGES);
        this.MESSAGES_FROM_SCHEDULE_MAP.put(MessageSchedule.ON_JOIN_LEVEL, this.ON_JOIN_LEVEL_MESSAGES);
        this.MESSAGES_FROM_SCHEDULE_MAP.put(MessageSchedule.ON_DEATH, this.ON_DEATH_MESSAGES);
        this.MESSAGES_FROM_SCHEDULE_MAP.put(MessageSchedule.ON_RESPAWN, this.ON_RESPAWN_MESSAGES);
    }

    public List<List<?>> allMessageLists() {
        return List.of(this.ON_FIRST_JOIN_MESSAGES, this.ON_JOIN_LEVEL_MESSAGES, this.ON_DEATH_MESSAGES, this.ON_RESPAWN_MESSAGES, this.ON_SLEEP_IN_BED_MESSAGES, this.ON_WAKE_UP_MESSAGES, this.OVERWORLD_TO_NETHER_MESSAGES, this.OVERWORLD_TO_END_MESSAGES, this.NETHER_TO_OVERWORLD_MESSAGES, this.END_TO_OVERWORLD_MESSAGES);
    }
}

