/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.automessage.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonFileHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, List<String>>>(){}.getType();

    public static Map<String, List<String>> read(String path) {
        Map map;
        File file = new File(path);
        if (!file.exists()) {
            return new HashMap<String, List<String>>();
        }
        FileReader reader = new FileReader(file);
        try {
            Map data = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
            map = data != null ? data : new HashMap();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HashMap<String, List<String>>();
            }
        }
        reader.close();
        return map;
    }

    public static boolean write(String path, Map<String, List<String>> data) {
        File file = new File(path);
        File tempFile = new File(path + ".tmp");
        try (FileWriter writer = new FileWriter(tempFile);){
            GSON.toJson(data, MAP_TYPE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void addTag(String path, String serverName, String message) {
        Map<String, List<String>> data = JsonFileHelper.read(path);
        data.computeIfAbsent(serverName, k -> new ArrayList()).add(message);
        JsonFileHelper.write(path, data);
    }

    public static void removeTag(String path, String serverName, String message) {
        Map<String, List<String>> data = JsonFileHelper.read(path);
        List<String> list = data.get(serverName);
        if (list != null) {
            list.remove(message);
            if (list.isEmpty()) {
                data.remove(serverName);
            }
            JsonFileHelper.write(path, data);
        }
    }

    public static boolean hasTag(String filePath, String serverName, String tag) {
        Map<String, List<String>> data = JsonFileHelper.read(filePath);
        return data.containsKey(serverName) && data.get(serverName).contains(tag);
    }

    public static boolean hasKey(String filePath, String serverName) {
        Map<String, List<String>> data = JsonFileHelper.read(filePath);
        return data.containsKey(serverName);
    }

    public static boolean anyKeyContainsTag(File file, String tag) {
        boolean bl;
        if (!file.exists()) {
            return false;
        }
        FileReader reader = new FileReader(file);
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
            Map data = (Map)gson.fromJson((Reader)reader, type);
            bl = data.values().stream().anyMatch(list -> list.contains(tag));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        ((Reader)reader).close();
        return bl;
    }
}

