/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.config;

import it.crystalnest.cobweb.api.config.CobwebConfig;
import it.crystalnest.cobweb.api.config.ConfigType;
import it.crystalnest.cobweb.platform.Services;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public abstract class ClientConfig
extends CobwebConfig {
    protected ClientConfig(ModConfigSpec.Builder builder) {
        super(builder);
    }

    protected static <T extends ClientConfig> T register(String modId, Function<ModConfigSpec.Builder, T> constructor) {
        ClientConfig.register(modId, ConfigType.CLIENT, constructor);
        if (Services.CONFIG == null) {
            throw new NullPointerException("Make sure you are on NeoForge or the mod Forge Config API Port is installed!");
        }
        Services.CONFIG.registerClientConfig(ClientConfig.getId(modId, ConfigType.CLIENT), ClientConfig.getSpec(modId));
        return ClientConfig.getConfig(modId);
    }

    @Nullable
    protected static <T extends ClientConfig> T getConfig(String modId) {
        return (T)((ClientConfig)ClientConfig.getConfig(modId, ConfigType.CLIENT));
    }

    @Nullable
    protected static ModConfigSpec getSpec(String modId) {
        return ClientConfig.getSpec(modId, ConfigType.CLIENT);
    }
}

