/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.logic;

import com.illusivesoulworks.veinmining.common.data.BlockGroupsResourceListener;
import com.illusivesoulworks.veinmining.common.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockGroups {
    private static final Map<String, Set<String>> BLOCK_TO_GROUP = new HashMap<String, Set<String>>();

    public static synchronized void rebuild() {
        BLOCK_TO_GROUP.clear();
        ArrayList<Set<String>> groups = new ArrayList<Set<String>>(BlockGroupsResourceListener.INSTANCE.getGroups());
        for (Set set : groups) {
            Set<String> blockGroup = BlockGroups.createGroup(set);
            for (String blockId : blockGroup) {
                BLOCK_TO_GROUP.merge(blockId, new HashSet<String>(blockGroup), (s1, s2) -> {
                    s1.addAll(s2);
                    return s1;
                });
            }
        }
    }

    public static Set<String> getGroup(String id) {
        return BLOCK_TO_GROUP.getOrDefault(id, new HashSet());
    }

    private static Set<String> createGroup(Set<String> ids) {
        HashSet<String> newGroup = new HashSet<String>();
        for (String id : ids) {
            Block block;
            ResourceLocation rl;
            if (id.charAt(0) == '#') {
                rl = ResourceLocation.tryParse((String)id.substring(1));
                if (rl == null) continue;
                newGroup.addAll(Services.PLATFORM.getBlocksFromTag(rl));
                continue;
            }
            rl = ResourceLocation.tryParse((String)id);
            if (rl == null || (block = Services.PLATFORM.getBlock(rl)) == Blocks.AIR) continue;
            newGroup.add(id);
        }
        return newGroup;
    }
}

