/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.ender_pack;

import java.util.function.Function;
import neoforge.com.cursee.ender_pack.EnderPackClient;
import neoforge.com.cursee.ender_pack.client.block.entity.renderer.EnderPackBlockEntityRenderer;
import neoforge.com.cursee.ender_pack.client.layer.EnderPackLayer;
import neoforge.com.cursee.ender_pack.client.model.EnderPackModel;
import neoforge.com.cursee.ender_pack.core.network.input.OpenEnderPackKeyNeoForge;
import neoforge.com.cursee.ender_pack.core.network.packet.NeoForgeOpenEnderPackC2SPacket;
import neoforge.com.cursee.ender_pack.core.registry.ModBlockEntities;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class EnderPackClientNeoForge {
    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)event.getSkin(PlayerSkin.Model.byName((String)skinName));
        if (renderer != null) {
            renderer.addLayer(factory.apply(renderer));
        }
    }

    @EventBusSubscriber(modid="ender_pack", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (OpenEnderPackKeyNeoForge.ENDER_PACK_KEY_MAPPING.consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new NeoForgeOpenEnderPackC2SPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber(modid="ender_pack", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModClientBusEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> EnderPackClient.init());
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(OpenEnderPackKeyNeoForge.ENDER_PACK_KEY_MAPPING);
        }

        @SubscribeEvent
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.ENDER_PACK, EnderPackBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterLayerDefinitionsForEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(EnderPackClient.ENDER_PACK_PLAYER_MODEL_LAYER_LOCATION, EnderPackModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void onAddLayersForEntityRenderers(EntityRenderersEvent.AddLayers event) {
            EnderPackClientNeoForge.addLayerToPlayerSkin(event, "default", EnderPackLayer::new);
            EnderPackClientNeoForge.addLayerToPlayerSkin(event, "slim", EnderPackLayer::new);
        }
    }
}

