/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.util.NBT;

public class ReactorPartTile
extends AbstractTileEntity<Tier, ReactorBlock> {
    private BlockPos corePos = BlockPos.ZERO;
    private boolean extractor;
    private boolean built;
    @Nullable
    private BlockCapabilityCache<IEnergyStorage, Direction> coreEnergyCache;
    @Nullable
    private BlockCapabilityCache<IItemHandler, Direction> coreItemCache;
    @Nullable
    private BlockCapabilityCache<IFluidHandler, Direction> coreFluidCache;

    public ReactorPartTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.REACTOR_PART.get(), pos, state, variant);
    }

    public ReactorPartTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag compound, HolderLookup.Provider registries) {
        super.readSync(compound, registries);
        this.built = compound.getBoolean("built");
        this.extractor = compound.getBoolean("extractor");
        this.corePos = NBT.readPos(compound, "core_pos");
    }

    @Override
    public CompoundTag writeSync(CompoundTag compound, HolderLookup.Provider registries) {
        compound.putBoolean("built", this.built);
        compound.putBoolean("extractor", this.extractor);
        NBT.writePos(compound, this.corePos, "core_pos");
        return super.writeSync(compound, registries);
    }

    public void demolish(Level world) {
        BlockEntity tile = world.getBlockEntity(this.corePos);
        if (tile instanceof ReactorTile) {
            ReactorTile reactor = (ReactorTile)tile;
            reactor.demolish(world);
        }
    }

    @Nullable
    public IEnergyStorage getCoreEnergyStorage() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.coreEnergyCache == null) {
                this.coreEnergyCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getCorePos(), null);
            }
            return (IEnergyStorage)this.coreEnergyCache.getCapability();
        }
        return (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getCorePos(), null);
    }

    @Nullable
    public IItemHandler getCoreItemHandler() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.coreItemCache == null) {
                this.coreItemCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getCorePos(), null);
            }
            return (IItemHandler)this.coreItemCache.getCapability();
        }
        return (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getCorePos(), null);
    }

    @Nullable
    public IFluidHandler getCoreFluidHandler() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.coreFluidCache == null) {
                this.coreFluidCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getCorePos(), null);
            }
            return (IFluidHandler)this.coreFluidCache.getCapability();
        }
        return (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getCorePos(), null);
    }

    public Optional<ReactorTile> core() {
        BlockEntity tile;
        if (this.level != null && (tile = this.level.getBlockEntity(this.corePos)) instanceof ReactorTile) {
            ReactorTile reactorTile = (ReactorTile)tile;
            return Optional.of(reactorTile);
        }
        return Optional.empty();
    }

    public BlockPos getCorePos() {
        return this.corePos;
    }

    public void setCorePos(BlockPos corePos) {
        if (!corePos.equals((Object)this.corePos)) {
            this.corePos = corePos;
            this.invalidateCapabilities();
        }
    }

    public void setExtractor(boolean extractor) {
        if (extractor != this.extractor) {
            this.extractor = extractor;
            this.invalidateCapabilities();
        }
    }

    public boolean isExtractor() {
        return this.extractor;
    }

    public void setBuilt(boolean built) {
        this.built = built;
    }

    public boolean isBuilt() {
        return this.built;
    }
}

