/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class EnergizingParticle
extends TextureSheetParticle {
    protected EnergizingParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
        this.lifetime = 20;
        this.alpha = 0.6f;
        this.quadSize = 0.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float f0 = (float)this.age / (float)this.lifetime;
            this.quadSize = Mth.sin((float)((float)((double)f0 * Math.PI))) / 8.0f;
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.depthMask((boolean)false);
        super.render(buffer, renderInfo, partialTicks);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet p_i50747_1_) {
            this.spriteSet = p_i50747_1_;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EnergizingParticle particle = new EnergizingParticle(worldIn, x, y, z);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

