/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import owmii.powah.client.ClientUtils;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.client.screen.container.AbstractContainerScreen;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.AbstractTileContainer;
import owmii.powah.network.Network;
import owmii.powah.network.packet.NextRedstoneModePacket;
import owmii.powah.util.Util;

public class AbstractTileScreen<T extends AbstractTileEntity<?, ?>, C extends AbstractTileContainer<T>>
extends AbstractContainerScreen<C> {
    protected final T te;
    protected IconButton redStoneButton = IconButton.EMPTY;
    protected final List<TankArea> tankAreas = new ArrayList<TankArea>();

    public AbstractTileScreen(C container, Inventory inv, Component title, Texture backGround) {
        super(container, inv, title, backGround);
        this.te = ((AbstractTileContainer)((Object)container)).te;
    }

    protected void renderTooltip(GuiGraphics gui, int x, int y) {
        for (TankArea tankArea : this.tankAreas) {
            if (!tankArea.contains(x - this.leftPos, y - this.topPos)) continue;
            Tank tank = tankArea.tank().get();
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (!tank.isEmpty()) {
                list.add(Component.translatable((String)tankArea.purposeTranslationKey()).withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)tank.getFluid().getHoverName().plainCopy().withStyle(ChatFormatting.AQUA)));
                list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Util.formatTankContent(tank)));
                tankArea.extraInfoSupplier().accept(tank.getFluid(), list);
            } else {
                list.add(Component.translatable((String)"info.lollipop.fluid").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.literal((String)"---").withStyle(ChatFormatting.DARK_GRAY)));
            }
            gui.renderComponentTooltip(this.font, list, x, y);
            return;
        }
        super.renderTooltip(gui, x, y);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            for (TankArea tankArea : this.tankAreas) {
                if (!tankArea.contains(mouseX - (double)this.leftPos, mouseY - (double)this.topPos)) continue;
                ((AbstractTileContainer)this.menu).interactWithTank(button == 1);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected final void addTankArea(Supplier<Tank> tank, int x, int y, int width, int height, String purposeTranslationKey, BiConsumer<FluidStack, List<Component>> extraInfoSupplier) {
        this.tankAreas.add(new TankArea(tank, x, y, width, height, purposeTranslationKey, extraInfoSupplier));
    }

    protected void addRedstoneButton(int x, int y) {
        if (this.hasRedstone()) {
            this.redStoneButton = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + this.imageWidth + x + 2, this.topPos + y + 3, Texture.REDSTONE.get((Object)((AbstractTileEntity)this.te).getRedstoneMode()), b -> {
                Network.toServer(new NextRedstoneModePacket(this.te.getBlockPos()));
                ((AbstractTileEntity)this.te).setRedstoneMode(((AbstractTileEntity)this.te).getRedstoneMode().next());
            }, (Screen)this).setTooltipSupplier(() -> List.of(((AbstractTileEntity)this.te).getRedstoneMode().getDisplayName())));
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (this.hasRedstone()) {
            this.redStoneButton.setTexture(Texture.REDSTONE.get((Object)((AbstractTileEntity)this.te).getRedstoneMode()));
        }
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.hasRedstone()) {
            Texture.REDSTONE_BTN_BG.draw(guiGraphics, this.redStoneButton.getX() - 2, this.redStoneButton.getY() - 4);
        }
        for (TankArea tankArea : this.tankAreas) {
            FluidStack fluidStack;
            TextureAtlasSprite sprite;
            Tank tank = tankArea.tank().get();
            if (tank.isEmpty() || (sprite = ClientUtils.getStillTexture(fluidStack = tank.getFluid())) == null) continue;
            int color = ClientUtils.getFluidColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            this.bindTexture(InventoryMenu.BLOCK_ATLAS);
            Draw.gaugeV(sprite, this.leftPos + tankArea.x, this.topPos + tankArea.y, tankArea.width, tankArea.height(), tank.getCapacity(), tank.getFluidAmount());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected boolean hasRedstone() {
        return true;
    }

    protected record TankArea(Supplier<Tank> tank, int x, int y, int width, int height, String purposeTranslationKey, BiConsumer<FluidStack, List<Component>> extraInfoSupplier) {
        boolean contains(double x, double y) {
            return x >= (double)this.x && y >= (double)this.y && x < (double)(this.x + this.width) && y < (double)(this.y + this.height);
        }
    }
}

