/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.item.Stacks;
import owmii.powah.lib.logistics.inventory.ItemStackHandler;
import owmii.powah.lib.logistics.inventory.ItemStackHandlerHelper;
import owmii.powah.util.Util;

public class Inventory
extends ItemStackHandler {
    @Nullable
    private IInventoryHolder tile;
    private boolean sendUpdates = true;

    public Inventory(int size) {
        this(size, null);
    }

    public Inventory(Stacks stacks) {
        this(stacks, null);
    }

    public Inventory(Stacks stacks, @Nullable IInventoryHolder tile) {
        super(stacks);
        this.tile = tile;
    }

    Inventory(int size, @Nullable IInventoryHolder tile) {
        super(size);
        this.tile = tile;
    }

    public static <I extends AbstractTileEntity> Inventory create(int size, @Nullable I tile) {
        return new Inventory(size, (IInventoryHolder)((Object)tile));
    }

    public static <I extends AbstractTileEntity> Inventory createBlank(@Nullable I tile) {
        return new Inventory(0, (IInventoryHolder)((Object)tile));
    }

    public static Inventory create(int size) {
        return new Inventory(size, null);
    }

    public static Inventory createBlank() {
        return new Inventory(0, null);
    }

    public void setTile(@Nullable IInventoryHolder tile) {
        this.tile = tile;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (this.isBlank()) {
            return;
        }
        nbt.putInt("Size", this.getSlots());
        super.deserializeNBT(nbt, registries);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        return this.isBlank() ? new CompoundTag() : super.serializeNBT(registries);
    }

    public Inventory set(int size) {
        this.stacks = Stacks.withSize(size, ItemStack.EMPTY);
        this.onContentsChanged(0);
        return this;
    }

    public Inventory add(int size) {
        this.stacks = Stacks.withSize(size + this.stacks.size(), ItemStack.EMPTY);
        return this;
    }

    public Stacks canPut(Stacks outputs, int ... slots) {
        return this.canPut(outputs, this.fromSlotArray(slots));
    }

    public Stacks canPut(Stacks outputs, Stacks slots) {
        Inventory inv = new Inventory(Stacks.from(slots).copy());
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (ItemStackHandlerHelper.insertItem(inv, stack.copy(), false).isEmpty()) continue;
            return Stacks.create();
        }
        return inv.getStacks();
    }

    public Stacks fromSlotArray(int ... slots) {
        Stacks stacks = Stacks.create();
        for (int i : slots) {
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.tile != null) {
            return this.tile.getSlotLimit(slot);
        }
        return super.getSlotLimit(slot);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canInsert(slot, stack);
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.canExtract(slot, this.getStackInSlot(slot)) ? super.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
    }

    public ItemStack extractItemFromSlot(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canExtract(slot, stack);
        }
        return true;
    }

    public void setSendUpdates(boolean sendUpdates) {
        this.sendUpdates = sendUpdates;
    }

    @Override
    public void onContentsChanged(int slot) {
        if (this.tile != null && this.sendUpdates) {
            this.tile.onSlotChanged(slot);
        }
    }

    public ItemStack getFirst() {
        return this.getStackInSlot(0);
    }

    public ItemStack getLast() {
        return this.getStackInSlot(this.getLastSlot());
    }

    public int getLastSlot() {
        return this.getSlots() - 1;
    }

    public Stacks getLast(int count) {
        Stacks stacks = Stacks.create();
        int size = this.stacks.size();
        for (int i = size - count; i < count; ++i) {
            stacks.add((ItemStack)this.stacks.get(i));
        }
        return stacks;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (ItemStack stack : this.stacks) {
            if (stack.getCount() >= stack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptySlot() {
        for (ItemStack stack : this.stacks) {
            if (!stack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSlotEmpty(int slot) {
        return ((ItemStack)this.stacks.get(slot)).isEmpty();
    }

    public ItemStack setSlotEmpty(int slot) {
        ItemStack stack = (ItemStack)this.stacks.set(slot, (Object)ItemStack.EMPTY);
        this.onContentsChanged(slot);
        return stack;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        ItemStack stack1 = (ItemStack)this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public void clear() {
        this.set(this.getSlots());
    }

    public boolean isBlank() {
        return this.stacks.isEmpty();
    }

    public Stacks getStacks() {
        return Stacks.from((NonNullList<ItemStack>)this.stacks);
    }

    public List<ItemStack> getNonEmptyStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.stacks);
        stacks.removeIf(ItemStack::isEmpty);
        return stacks;
    }

    public ItemStack addNext(ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.isItemValid(i, stack)) continue;
            this.insertItem(i, stack.copy(), false);
            return stack.copy();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeNext() {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.setSlotEmpty(i);
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate, int ... ex) {
        if (stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (Util.anyMatch(ex, i) || !(stack = this.insertItem(i, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public void drop(Level world, BlockPos pos) {
        this.stacks.forEach(stack -> Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack));
        this.clear();
    }

    public void drop(int index, Level world, BlockPos pos) {
        ItemStack stack = this.getStackInSlot(index);
        if (!stack.isEmpty()) {
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            this.setStackInSlot(index, ItemStack.EMPTY);
        }
    }

    public static int calcRedstone(ItemStackHandler inv) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(inv.getSlotLimit(j), itemstack.getMaxStackSize());
            ++i;
        }
        return Mth.floor((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

