/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeLevelManager;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.faucet.APIFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BeehiveInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BrewingStandInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ConcreteInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ContainerItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FiniteFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FullBucketCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.LiquidBlockInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.MudInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.PowderSnowCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SappyLogInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidProviderInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SpongeInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.WaterCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.XPDroppingInteraction;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.BlockTestLevel;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FaucetBehaviorsManager
extends SimpleJsonResourceReloadListener {
    private static final Codec<Either<DataItemInteraction, DataFluidInteraction>> CODEC = Codec.either(DataItemInteraction.CODEC, DataFluidInteraction.CODEC);
    private static final Set<Runnable> SERVER_LISTENERS = new HashSet<Runnable>();
    private static final SidedInstance<FaucetBehaviorsManager> INSTANCES = SidedInstance.of(FaucetBehaviorsManager::new);
    private final Set<Object> dataInteractions = new HashSet<Object>();
    private final HolderLookup.Provider registryAccess;

    public static FaucetBehaviorsManager getInstance(HolderLookup.Provider ra) {
        return (FaucetBehaviorsManager)((Object)INSTANCES.get(ra));
    }

    public static FaucetBehaviorsManager getInstance(@NotNull Level level) {
        Preconditions.checkNotNull((Object)level);
        return FaucetBehaviorsManager.getInstance((HolderLookup.Provider)level.registryAccess());
    }

    public static synchronized void addRegisterFaucetInteraction(Runnable listener) {
        SERVER_LISTENERS.add(listener);
    }

    public FaucetBehaviorsManager(HolderLookup.Provider ra) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "faucet_interactions");
        this.registryAccess = ra;
        INSTANCES.set(ra, (Object)this);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.dataInteractions.clear();
        RegistryOps ops = ForgeHelper.conditionalOps((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registryAccess, (SimplePreparableReloadListener)this);
        Codec codec = ForgeHelper.conditionalCodec(CODEC);
        map.forEach((key, json) -> {
            try {
                Optional either = (Optional)codec.parse((DynamicOps)ops, json).getOrThrow();
                if (either.isPresent()) {
                    Either o = ((Either)either.get()).mapBoth(i -> i, f -> f);
                    this.dataInteractions.add(o);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for faucet interaction {}", key, (Object)e);
            }
        });
        if (!this.dataInteractions.isEmpty()) {
            Supplementaries.LOGGER.info("Loaded  {} custom faucet interactions", (Object)this.dataInteractions.size());
        }
    }

    public static void reloadWithLevel(ServerLevel level) {
        FaucetBehaviorsManager instance = FaucetBehaviorsManager.getInstance((HolderLookup.Provider)level.registryAccess());
        FaucetBlockTile.clearBehaviors();
        instance.dataInteractions.forEach(FaucetBlockTile::registerInteraction);
        FaucetBlockTile.registerInteraction(new SoftFluidProviderInteraction());
        FaucetBlockTile.registerInteraction(new WaterCauldronInteraction());
        FaucetBlockTile.registerInteraction(new FullBucketCauldronInteraction(Blocks.LAVA_CAULDRON.defaultBlockState(), Items.LAVA_BUCKET.getDefaultInstance()));
        FaucetBlockTile.registerInteraction(new PowderSnowCauldronInteraction());
        FaucetBlockTile.registerInteraction(new BeehiveInteraction());
        FaucetBlockTile.registerInteraction(new SoftFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new APIFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new BrewingStandInteraction());
        FaucetBlockTile.registerInteraction(new FiniteFluidInteraction());
        FaucetBlockTile.registerInteraction(new LiquidBlockInteraction());
        FaucetBlockTile.registerInteraction(new SpongeInteraction());
        FaucetBlockTile.registerInteraction(new XPDroppingInteraction());
        FaucetBlockTile.registerInteraction(new ConcreteInteraction());
        FaucetBlockTile.registerInteraction(new MudInteraction());
        FaucetBlockTile.registerInteraction(new ContainerItemInteraction());
        if (CompatHandler.AUTUMNITY) {
            FaucetBlockTile.registerInteraction(new SappyLogInteraction());
        }
        BlockTestLevel testLevel = BlockTestLevel.get(level);
        Player player = FakePlayerManager.getDefault((Level)testLevel);
        InteractionHand hand = InteractionHand.MAIN_HAND;
        BlockState emptyCauldron = Blocks.CAULDRON.defaultBlockState();
        for (Map.Entry e : CauldronInteraction.EMPTY.map().entrySet()) {
            Item i = (Item)e.getKey();
            CauldronInteraction interaction = (CauldronInteraction)e.getValue();
            if (Utils.getID((Item)i).getNamespace().equals("minecraft")) continue;
            testLevel.setup();
            ItemStack fullBucket = i.getDefaultInstance();
            ItemStack fullBucketCopy = fullBucket.copy();
            player.setItemInHand(hand, fullBucket);
            interaction.interact(emptyCauldron, (Level)testLevel, BlockPos.ZERO, player, hand, fullBucket);
            BlockState fullCauldron = testLevel.blockState;
            if (fullCauldron == null || fullCauldron.hasProperty((Property)LayeredCauldronBlock.LEVEL) && PlatHelper.getPlatform().isForge()) continue;
            FaucetBlockTile.registerInteraction(new FullBucketCauldronInteraction(fullCauldron, fullBucketCopy));
        }
        FakeLevelManager.invalidate((Level)testLevel);
        SERVER_LISTENERS.forEach(Runnable::run);
    }

    @Deprecated(forRemoval=true)
    public static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid, @Nullable CompoundTag tag) {
    }
}

