/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.entities.RedMerchantEntity;
import net.mehvahdjukaar.supplementaries.common.entities.goals.ISuppEvoker;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.Level;

public class EvokerRedMerchantWololooSpellGoal
extends Goal {
    private final TargetingConditions selector = TargetingConditions.forNonCombat().range(16.0);
    private final Evoker evoker;
    private final ISuppEvoker suppEvoker;
    protected int attackWarmupDelay;
    protected int nextAttackTickCount;

    public EvokerRedMerchantWololooSpellGoal(Evoker evoker) {
        this.evoker = evoker;
        this.suppEvoker = (ISuppEvoker)evoker;
    }

    public boolean canUse() {
        if (this.evoker.getTarget() != null) {
            return false;
        }
        if (this.evoker.isCastingSpell()) {
            return false;
        }
        if (this.evoker.tickCount < this.nextAttackTickCount) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)this.evoker.level(), (Entity)this.evoker)) {
            return false;
        }
        List list = this.evoker.level().getNearbyEntities(WanderingTrader.class, this.selector, (LivingEntity)this.evoker, this.evoker.getBoundingBox().inflate(16.0, 4.0, 16.0));
        if (list.isEmpty()) {
            return false;
        }
        ((ISuppEvoker)this.evoker).supplementaries$setCustomWololoo((LivingEntity)list.get(this.evoker.getRandom().nextInt(list.size())));
        return true;
    }

    public boolean canContinueToUse() {
        return this.suppEvoker.supplementaries$getCustomWololoo() != null && this.attackWarmupDelay > 0;
    }

    public void stop() {
        super.stop();
        this.suppEvoker.supplementaries$setCustomWololoo(null);
    }

    protected void performSpellCasting() {
        RedMerchantEntity mob;
        LivingEntity entity = this.suppEvoker.supplementaries$getCustomWololoo();
        if (entity != null && entity.isAlive() && ForgeHelper.canLivingConvert((LivingEntity)entity, ModEntities.RED_MERCHANT.get(), timer -> {}) && !entity.isRemoved() && (mob = (RedMerchantEntity)ModEntities.RED_MERCHANT.get().create(entity.level())) != null) {
            CompoundTag tag = new CompoundTag();
            entity.saveWithoutId(tag);
            tag.remove("Offers");
            mob.load(tag);
            entity.discard();
            mob.removeEffect(MobEffects.INVISIBILITY);
            entity.level().addFreshEntity((Entity)mob);
        }
    }

    protected int getCastWarmupTime() {
        return 40;
    }

    protected int getCastingTime() {
        return 60;
    }

    protected int getCastingInterval() {
        return 140;
    }

    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.EVOKER_PREPARE_WOLOLO;
    }

    protected SpellcasterIllager.IllagerSpell getSpell() {
        return SpellcasterIllager.IllagerSpell.WOLOLO;
    }

    public void start() {
        this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
        this.suppEvoker.supplementaries$setSpellCastingTime(this.getCastingTime());
        this.nextAttackTickCount = this.evoker.tickCount + this.getCastingInterval();
        SoundEvent soundEvent = this.getSpellPrepareSound();
        if (soundEvent != null) {
            this.evoker.playSound(soundEvent, 1.0f, 1.0f);
        }
        this.evoker.setIsCastingSpell(this.getSpell());
    }

    public void tick() {
        --this.attackWarmupDelay;
        if (this.attackWarmupDelay == 0) {
            this.performSpellCasting();
            this.evoker.playSound(SoundEvents.EVOKER_CAST_SPELL, 1.0f, 1.0f);
        }
    }
}

