/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.overrides;

import net.mehvahdjukaar.supplementaries.common.entities.SlimeBallEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseBehavior;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

class ThrowableSlimeballBehavior
implements ItemUseBehavior {
    ThrowableSlimeballBehavior() {
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.Tweaks.SLIMED_EFFECT.get() != false && CommonConfigs.Tweaks.THROWABLE_SLIMEBALLS.get() != false;
    }

    @Override
    @Nullable
    public MutableComponent getTooltip() {
        return Component.translatable((String)"message.supplementaries.throwable_brick");
    }

    @Override
    public boolean appliesToItem(Item item) {
        return item.builtInRegistryHolder().is(ModTags.SLIMEBALLS) && !item.components().has(DataComponents.FOOD);
    }

    @Override
    public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        world.playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.SLIMEBALL_THROW.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            SlimeBallEntity projectile = new SlimeBallEntity((LivingEntity)player);
            projectile.setItem(stack);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, projectile.getDefaultShootVelocity(), 1.0f);
            world.addFreshEntity((Entity)projectile);
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

