/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PicklePacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, PicklePacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("pickle"), PicklePacket::new);
    protected UUID playerID;
    protected final boolean on;
    private final boolean isJar;

    public PicklePacket(UUID appliesTo, boolean on, boolean isJar) {
        this.playerID = appliesTo;
        this.on = on;
        this.isJar = isJar;
    }

    public PicklePacket(FriendlyByteBuf buf) {
        this.on = buf.readBoolean();
        this.isJar = buf.readBoolean();
        if (buf.isReadable()) {
            this.playerID = buf.readUUID();
        }
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.on);
        buf.writeBoolean(this.isJar);
        if (this.playerID != null) {
            buf.writeUUID(this.playerID);
        }
    }

    public void handle(Message.Context context) {
        if (context.getDirection() == Message.NetworkDir.CLIENT_BOUND) {
            PickleData.set(this.playerID, this.on, this.isJar);
        } else {
            Player player = context.getPlayer();
            UUID id = player.getGameProfile().getId();
            if (PickleData.isDev(id, this.isJar)) {
                PickleData.set(id, this.on, this.isJar);
                this.playerID = id;
                for (ServerPlayer p : player.getServer().getPlayerList().getPlayers()) {
                    if (p == player) continue;
                    NetworkHelper.sendToClientPlayer((ServerPlayer)p, (CustomPacketPayload)new PicklePacket(this.playerID, this.on, this.isJar));
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

