/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.events;

import com.direwolf20.buildinggadgets2.common.blockentities.RenderBlockBE;
import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class ServerTickHandler {
    public static final HashMap<UUID, ServerBuildList> buildMap = new HashMap();

    @SubscribeEvent
    public static void handleTickEndEvent(ServerTickEvent.Pre event) {
        if (buildMap.isEmpty()) {
            return;
        }
        for (UUID uuid : buildMap.keySet()) {
            ServerBuildList serverBuildList = buildMap.get(uuid);
            ServerPlayer player = event.getServer().getPlayerList().getPlayer(serverBuildList.playerUUID);
            if (player == null) {
                ServerTickHandler.stopBuilding(uuid);
                continue;
            }
            int min = serverBuildList.originalSize < 60 ? 1 : 5;
            int max = 50;
            int amountPerTick = Math.min(Math.max((int)Math.floor(serverBuildList.originalSize / 300), min), max);
            for (int i = 0; i < amountPerTick; ++i) {
                if (serverBuildList.buildType.equals((Object)ServerBuildList.BuildType.BUILD)) {
                    ServerTickHandler.build(serverBuildList, (Player)player);
                    continue;
                }
                if (serverBuildList.buildType.equals((Object)ServerBuildList.BuildType.EXCHANGE)) {
                    ServerTickHandler.exchange(serverBuildList, (Player)player);
                    continue;
                }
                if (serverBuildList.buildType.equals((Object)ServerBuildList.BuildType.DESTROY)) {
                    ServerTickHandler.remove(serverBuildList, (Player)player);
                    continue;
                }
                if (serverBuildList.buildType.equals((Object)ServerBuildList.BuildType.UNDO_DESTROY)) {
                    ServerTickHandler.undoDestroy(serverBuildList, (Player)player);
                    continue;
                }
                if (!serverBuildList.buildType.equals((Object)ServerBuildList.BuildType.CUT)) continue;
                ServerTickHandler.cut(serverBuildList, (Player)player);
            }
        }
        ServerTickHandler.removeEmptyLists(event);
    }

    public static void addToMap(UUID buildUUID, StatePos statePos, Level level, byte renderType, Player player, boolean neededItems, boolean returnItems, ItemStack gadget, ServerBuildList.BuildType buildType, boolean dropContents, BlockPos lookingAt) {
        GlobalPos boundPos = GadgetNBT.getBoundPos(gadget);
        int direction = boundPos == null ? -1 : GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.BIND_DIRECTION.getName());
        ServerBuildList serverBuildList = buildMap.computeIfAbsent(buildUUID, k -> new ServerBuildList(level, new ArrayList<StatePos>(), renderType, player.getUUID(), neededItems, returnItems, buildUUID, gadget, buildType, dropContents, lookingAt, boundPos, direction));
        serverBuildList.statePosList.add(statePos);
        serverBuildList.originalSize = serverBuildList.statePosList.size();
    }

    public static void addTEData(UUID buildUUID, ArrayList<TagPos> teData) {
        ServerBuildList serverBuildList = buildMap.get(buildUUID);
        if (serverBuildList == null) {
            return;
        }
        serverBuildList.teData = teData;
    }

    public static boolean gadgetWorking(UUID gadgetUUID) {
        return buildMap.values().stream().anyMatch(e -> GadgetNBT.getUUID(e.gadget).equals(gadgetUUID));
    }

    public static void setCutStart(UUID buildUUID, BlockPos cutStart) {
        ServerBuildList serverBuildList = buildMap.get(buildUUID);
        serverBuildList.cutStart = cutStart;
        if (serverBuildList.buildType.equals((Object)ServerBuildList.BuildType.CUT)) {
            for (StatePos statePos : serverBuildList.statePosList) {
                serverBuildList.actuallyBuildList.add(new StatePos(Blocks.VOID_AIR.defaultBlockState(), statePos.pos.subtract((Vec3i)serverBuildList.cutStart)));
            }
        }
    }

    public static void stopBuilding(UUID buildUUID) {
        if (!buildMap.containsKey(buildUUID)) {
            return;
        }
        ServerBuildList serverBuildList = buildMap.get(buildUUID);
        serverBuildList.statePosList.clear();
    }

    public static void removeEmptyLists(ServerTickEvent.Pre event) {
        Iterator<Map.Entry<UUID, ServerBuildList>> iterator = buildMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ServerBuildList> entry = iterator.next();
            ServerBuildList serverBuildList = entry.getValue();
            if (!entry.getValue().statePosList.isEmpty()) continue;
            ServerPlayer player = event.getServer().getPlayerList().getPlayer(serverBuildList.playerUUID);
            if (serverBuildList.teData != null && !serverBuildList.buildType.equals((Object)ServerBuildList.BuildType.CUT) && player != null) {
                BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(serverBuildList.level.getServer()).overworld());
                bg2Data.getCopyPasteList(GadgetNBT.getUUID(serverBuildList.gadget), true);
                bg2Data.getTEMap(GadgetNBT.getUUID(serverBuildList.gadget));
                bg2Data.popUndoList(GadgetNBT.getUUID(serverBuildList.gadget));
            }
            iterator.remove();
        }
    }

    public static void build(ServerBuildList serverBuildList, Player player) {
        FluidState fluidState;
        Level level = serverBuildList.level;
        ArrayList<StatePos> statePosList = serverBuildList.statePosList;
        if (statePosList.isEmpty()) {
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        StatePos statePos = statePosList.remove(0);
        if (statePos.state.equals(Blocks.VOID_AIR.defaultBlockState())) {
            return;
        }
        ArrayList<StatePos> undoList = bg2Data.peekUndoList(GadgetNBT.getUUID(serverBuildList.gadget));
        if (undoList != null && undoList.contains(statePos)) {
            return;
        }
        BlockPos blockPos = statePos.pos.offset((Vec3i)serverBuildList.lookingAt);
        BlockState blockState = statePos.state;
        if (!blockState.getFluidState().isEmpty() && !(fluidState = blockState.getFluidState()).isEmpty() && fluidState.isSource()) {
            boolean canDestContainFluid;
            Fluid fluid = fluidState.getType();
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            boolean bl = canDestContainFluid = !fluid.getFluidType().isVaporizedOnPlacement(level, blockPos, fluidStack);
            if (!canDestContainFluid) {
                return;
            }
        }
        if (!blockState.canSurvive((LevelReader)level, blockPos)) {
            if (serverBuildList.retryList.contains(blockPos)) {
                return;
            }
            statePosList.add(statePos);
            serverBuildList.retryList.add(blockPos);
            return;
        }
        if (!level.getBlockState(blockPos).canBeReplaced()) {
            return;
        }
        List<ItemStack> neededItems = GadgetUtils.getDropsForBlockState((ServerLevel)level, blockPos, blockState, player);
        if (blockState.getFluidState().isEmpty()) {
            if (!player.isCreative() && serverBuildList.needItems && !BuildingUtils.removeStacksFromInventory(player, neededItems, true, serverBuildList.boundPos, serverBuildList.getDirection())) {
                return;
            }
        } else {
            FluidState fluidState2 = blockState.getFluidState();
            if (!fluidState2.isEmpty() && fluidState2.isSource()) {
                Fluid fluid = fluidState2.getType();
                FluidStack fluidStack = new FluidStack(fluid, 1000);
                if (!player.isCreative() && serverBuildList.needItems && !BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, true, serverBuildList.boundPos, serverBuildList.getDirection())) {
                    return;
                }
            }
        }
        boolean placed = level.setBlockAndUpdate(blockPos, ((RenderBlock)((Object)Registration.RenderBlock.get())).defaultBlockState());
        RenderBlockBE be = (RenderBlockBE)level.getBlockEntity(blockPos);
        if (!placed || be == null) {
            return;
        }
        if (blockState.getFluidState().isEmpty()) {
            if (!player.isCreative() && serverBuildList.needItems) {
                BuildingUtils.removeStacksFromInventory(player, neededItems, false, serverBuildList.boundPos, serverBuildList.getDirection());
            }
        } else {
            FluidState fluidState3 = blockState.getFluidState();
            if (!fluidState3.isEmpty() && fluidState3.isSource()) {
                Fluid fluid = fluidState3.getType();
                FluidStack fluidStack = new FluidStack(fluid, 1000);
                if (!player.isCreative() && serverBuildList.needItems) {
                    BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, false, serverBuildList.boundPos, serverBuildList.getDirection());
                }
            }
        }
        be.setRenderData(Blocks.AIR.defaultBlockState(), blockState, serverBuildList.renderType);
        if (serverBuildList.teData == null && bg2Data.containsUndoList(serverBuildList.buildUUID)) {
            serverBuildList.addToBuiltList(new StatePos(blockState, blockPos));
            bg2Data.addToUndoList(serverBuildList.buildUUID, serverBuildList.actuallyBuildList, level);
        }
        if (serverBuildList.teData != null) {
            serverBuildList.addToBuiltList(new StatePos(blockState, statePos.pos));
            bg2Data.addToUndoList(GadgetNBT.getUUID(serverBuildList.gadget), serverBuildList.actuallyBuildList, level);
            CompoundTag compoundTag = serverBuildList.getTagForPos(blockPos);
            if (!compoundTag.isEmpty()) {
                be.setBlockEntityData(compoundTag);
                bg2Data.addToTEMap(GadgetNBT.getUUID(serverBuildList.gadget), serverBuildList.teData);
            }
        }
    }

    public static void exchange(ServerBuildList serverBuildList, Player player) {
        Fluid fluid;
        FluidState fluidState;
        FluidState fluidState2;
        Level level = serverBuildList.level;
        ArrayList<StatePos> statePosList = serverBuildList.statePosList;
        if (statePosList.isEmpty()) {
            return;
        }
        StatePos statePos = statePosList.remove(0);
        if (statePos.state.equals(Blocks.VOID_AIR.defaultBlockState())) {
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        ArrayList<StatePos> undoList = bg2Data.peekUndoList(GadgetNBT.getUUID(serverBuildList.gadget));
        if (undoList != null && undoList.contains(statePos)) {
            return;
        }
        BlockPos blockPos = statePos.pos;
        if (!serverBuildList.lookingAt.equals((Object)GadgetNBT.nullPos)) {
            blockPos = statePos.pos.offset((Vec3i)serverBuildList.lookingAt);
        }
        BlockState blockState = statePos.state;
        BlockState oldState = level.getBlockState(blockPos);
        int drawSize = -1;
        if (oldState.equals(blockState)) {
            return;
        }
        if (!blockState.getFluidState().isEmpty() && !(fluidState2 = blockState.getFluidState()).isEmpty() && fluidState2.isSource()) {
            boolean canDestContainFluid;
            Fluid fluid2 = fluidState2.getType();
            FluidStack fluidStack = new FluidStack(fluid2, 1000);
            boolean bl = canDestContainFluid = !fluid2.getFluidType().isVaporizedOnPlacement(level, blockPos, fluidStack);
            if (!canDestContainFluid) {
                return;
            }
        }
        if (!blockState.canSurvive((LevelReader)level, blockPos)) {
            if (serverBuildList.retryList.contains(blockPos)) {
                return;
            }
            statePosList.add(statePos);
            serverBuildList.retryList.add(blockPos);
            return;
        }
        ArrayList<ItemStack> neededItems = new ArrayList<ItemStack>();
        if (blockState.getFluidState().isEmpty()) {
            if (!player.isCreative() && serverBuildList.needItems && !blockState.isAir()) {
                neededItems.addAll(GadgetUtils.getDropsForBlockState((ServerLevel)level, blockPos, blockState, player));
                if (!BuildingUtils.removeStacksFromInventory(player, neededItems, true, serverBuildList.boundPos, serverBuildList.getDirection())) {
                    return;
                }
            }
        } else {
            FluidState fluidState3 = blockState.getFluidState();
            if (!fluidState3.isEmpty() && fluidState3.isSource()) {
                Fluid fluid3 = fluidState3.getType();
                FluidStack fluidStack = new FluidStack(fluid3, 1000);
                if (!player.isCreative() && serverBuildList.needItems && !BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, true, serverBuildList.boundPos, serverBuildList.getDirection())) {
                    return;
                }
            }
        }
        boolean placed = false;
        BlockState oldRenderState = oldState;
        if (oldState.getBlock() instanceof RenderBlock) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof RenderBlockBE) {
                RenderBlockBE renderBlockBE = (RenderBlockBE)blockEntity;
                oldState = renderBlockBE.targetBlock;
                oldRenderState = renderBlockBE.renderBlock;
                drawSize = renderBlockBE.drawSize;
                placed = true;
            }
        } else {
            placed = level.setBlockAndUpdate(blockPos, ((RenderBlock)((Object)Registration.RenderBlock.get())).defaultBlockState());
        }
        RenderBlockBE be = (RenderBlockBE)level.getBlockEntity(blockPos);
        if (!placed || be == null) {
            return;
        }
        if (blockState.getFluidState().isEmpty()) {
            if (!player.isCreative() && serverBuildList.needItems && !blockState.isAir()) {
                BuildingUtils.removeStacksFromInventory(player, neededItems, false, serverBuildList.boundPos, serverBuildList.getDirection());
            }
        } else {
            fluidState = blockState.getFluidState();
            if (!fluidState.isEmpty() && fluidState.isSource()) {
                fluid = fluidState.getType();
                FluidStack fluidStack = new FluidStack(fluid, 1000);
                if (!player.isCreative() && serverBuildList.needItems) {
                    BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, false, serverBuildList.boundPos, serverBuildList.getDirection());
                }
            }
        }
        if (!player.isCreative() && serverBuildList.returnItems && !oldState.isAir()) {
            if (!oldState.getFluidState().isEmpty()) {
                fluidState = oldState.getFluidState();
                if (!fluidState.isEmpty() && fluidState.isSource()) {
                    fluid = fluidState.getType();
                    FluidStack returnStack = new FluidStack(fluid, 1000);
                    BuildingUtils.giveFluidToPlayer(player, returnStack, serverBuildList.boundPos, serverBuildList.getDirection());
                }
            } else {
                List<ItemStack> returnedItems = GadgetUtils.getDropsForBlockStateGadget((ServerLevel)level, blockPos, oldState, serverBuildList.gadget);
                for (ItemStack returnedItem : returnedItems) {
                    BuildingUtils.giveItemToPlayer(player, returnedItem, serverBuildList.boundPos, serverBuildList.getDirection());
                }
            }
        }
        if (oldRenderState.equals(blockState)) {
            be.setRenderData(Blocks.AIR.defaultBlockState(), blockState, serverBuildList.renderType);
        } else {
            be.setRenderData(oldState, blockState, serverBuildList.renderType);
        }
        if (drawSize != -1) {
            be.drawSize = (byte)drawSize;
        }
        if (serverBuildList.teData == null && bg2Data.containsUndoList(serverBuildList.buildUUID)) {
            serverBuildList.addToBuiltList(new StatePos(oldState, blockPos));
            bg2Data.addToUndoList(serverBuildList.buildUUID, serverBuildList.actuallyBuildList, level);
        }
        if (serverBuildList.teData != null) {
            serverBuildList.addToBuiltList(new StatePos(blockState, statePos.pos));
            bg2Data.addToUndoList(GadgetNBT.getUUID(serverBuildList.gadget), serverBuildList.actuallyBuildList, level);
            CompoundTag compoundTag = serverBuildList.getTagForPos(blockPos);
            if (!compoundTag.isEmpty()) {
                be.setBlockEntityData(compoundTag);
                bg2Data.addToTEMap(GadgetNBT.getUUID(serverBuildList.gadget), serverBuildList.teData);
            }
        }
    }

    public static void remove(ServerBuildList serverBuildList, Player player) {
        BlockEntity blockEntity;
        Level level = serverBuildList.level;
        ArrayList<StatePos> statePosList = serverBuildList.statePosList;
        if (statePosList.isEmpty()) {
            return;
        }
        StatePos statePos = statePosList.remove(0);
        BlockPos blockPos = statePos.pos;
        int drawSize = -99;
        BlockState oldState = level.getBlockState(blockPos);
        if (oldState.isAir() || !GadgetUtils.isValidBlockState(oldState, level, blockPos)) {
            return;
        }
        if (oldState.getBlock() instanceof RenderBlock && (blockEntity = level.getBlockEntity(blockPos)) instanceof RenderBlockBE) {
            RenderBlockBE renderBlockBE = (RenderBlockBE)blockEntity;
            oldState = renderBlockBE.renderBlock;
            drawSize = renderBlockBE.drawSize;
        }
        if (!serverBuildList.dropContents) {
            level.removeBlockEntity(blockPos);
        }
        level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 48);
        StatePos affectedBlock = new StatePos(oldState, blockPos);
        if (serverBuildList.returnItems) {
            if (!oldState.getFluidState().isEmpty()) {
                FluidState fluidState = oldState.getFluidState();
                if (!fluidState.isEmpty() && fluidState.isSource()) {
                    Fluid fluid = fluidState.getType();
                    FluidStack returnStack = new FluidStack(fluid, 1000);
                    BuildingUtils.giveFluidToPlayer(player, returnStack, serverBuildList.boundPos, serverBuildList.getDirection());
                }
            } else {
                List<ItemStack> returnedItems = GadgetUtils.getDropsForBlockState((ServerLevel)level, blockPos, oldState, player);
                for (ItemStack returnedItem : returnedItems) {
                    BuildingUtils.giveItemToPlayer(player, returnedItem, serverBuildList.boundPos, serverBuildList.getDirection());
                }
            }
        }
        boolean placed = level.setBlock(affectedBlock.pos, ((RenderBlock)((Object)Registration.RenderBlock.get())).defaultBlockState(), 3);
        RenderBlockBE be = (RenderBlockBE)level.getBlockEntity(affectedBlock.pos);
        if (placed && be != null) {
            be.setRenderData(affectedBlock.state, Blocks.AIR.defaultBlockState(), serverBuildList.renderType);
            if (drawSize != -99) {
                be.drawSize = (byte)drawSize;
            }
        }
        serverBuildList.addToBuiltList(affectedBlock);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        if (bg2Data.containsUndoList(serverBuildList.buildUUID)) {
            bg2Data.addToUndoList(serverBuildList.buildUUID, serverBuildList.actuallyBuildList, level);
        }
    }

    public static void undoDestroy(ServerBuildList serverBuildList, Player player) {
        Level level = serverBuildList.level;
        ArrayList<StatePos> statePosList = serverBuildList.statePosList;
        if (statePosList.isEmpty()) {
            return;
        }
        StatePos statePos = statePosList.remove(0);
        BlockPos blockPos = statePos.pos;
        BlockState blockState = statePos.state;
        if (blockState.isAir()) {
            return;
        }
        BlockState oldState = level.getBlockState(blockPos);
        if (!oldState.canBeReplaced() && !(oldState.getBlock() instanceof RenderBlock)) {
            return;
        }
        if (oldState.getBlock() instanceof RenderBlock) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof RenderBlockBE) {
                RenderBlockBE renderBlockBE = (RenderBlockBE)blockEntity;
                byte drawSize = renderBlockBE.drawSize;
                renderBlockBE.setRenderData(Blocks.AIR.defaultBlockState(), blockState, serverBuildList.renderType);
                renderBlockBE.drawSize = drawSize;
            }
        } else {
            boolean placed = level.setBlockAndUpdate(blockPos, ((RenderBlock)((Object)Registration.RenderBlock.get())).defaultBlockState());
            RenderBlockBE be = (RenderBlockBE)level.getBlockEntity(blockPos);
            if (!placed || be == null) {
                return;
            }
            be.setRenderData(oldState, blockState, serverBuildList.renderType);
        }
    }

    public static void cut(ServerBuildList serverBuildList, Player player) {
        ArrayList<StatePos> statePosList;
        Level level = serverBuildList.level;
        if (serverBuildList.teData == null) {
            serverBuildList.teData = new ArrayList();
        }
        if ((statePosList = serverBuildList.statePosList).isEmpty()) {
            return;
        }
        StatePos statePos = statePosList.remove(0);
        BlockPos blockPos = statePos.pos;
        BlockState blockState = level.getBlockState(blockPos);
        boolean doRemove = false;
        if (GadgetUtils.isValidBlockState(blockState, level, blockPos) && GadgetCutPaste.customCutValidation(blockState, level, player, blockPos)) {
            serverBuildList.updateActuallyBuiltList(new StatePos(blockState, blockPos.subtract((Vec3i)serverBuildList.cutStart)));
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (!blockState.isAir()) {
                doRemove = true;
            }
            if (blockEntity != null) {
                CompoundTag blockTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                TagPos tagPos = new TagPos(blockTag, blockPos.subtract((Vec3i)serverBuildList.cutStart));
                serverBuildList.teData.add(tagPos);
            }
        } else {
            serverBuildList.updateActuallyBuiltList(new StatePos(Blocks.AIR.defaultBlockState(), blockPos.subtract((Vec3i)serverBuildList.cutStart)));
        }
        UUID uuid = GadgetNBT.getUUID(serverBuildList.gadget);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(player.level().getServer()).overworld());
        bg2Data.addToCopyPaste(uuid, serverBuildList.actuallyBuildList);
        bg2Data.addToTEMap(uuid, serverBuildList.teData);
        if (doRemove) {
            level.removeBlockEntity(blockPos);
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 48);
            StatePos affectedBlock = new StatePos(blockState, blockPos);
            boolean placed = level.setBlock(affectedBlock.pos, ((RenderBlock)((Object)Registration.RenderBlock.get())).defaultBlockState(), 3);
            RenderBlockBE be = (RenderBlockBE)level.getBlockEntity(affectedBlock.pos);
            if (placed && be != null) {
                be.setRenderData(affectedBlock.state, Blocks.AIR.defaultBlockState(), serverBuildList.renderType);
            }
        }
    }
}

