/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.VecHelpers;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class Copy
extends BaseMode {
    public Copy() {
        super(false);
    }

    @Override
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"buildinggadgets2", (String)"copy");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        int maxSize;
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        ItemStack heldItem = BaseGadget.getGadget(player);
        if (!(heldItem.getItem() instanceof GadgetCopyPaste)) {
            return coordinates;
        }
        Level level = player.level();
        BlockPos copyStart = GadgetNBT.getCopyStartPos(heldItem);
        BlockPos copyEnd = GadgetNBT.getCopyEndPos(heldItem);
        if (copyStart.equals((Object)GadgetNBT.nullPos) || copyEnd.equals((Object)GadgetNBT.nullPos)) {
            return coordinates;
        }
        AABB area = VecHelpers.aabbFromBlockPos(copyStart, copyEnd);
        int maxAxis = 500;
        if (area.getXsize() > (double)maxAxis) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.axistoolarge", (Object[])new Object[]{"x", maxAxis, area.getXsize()}), false);
            return coordinates;
        }
        if (area.getYsize() > (double)maxAxis) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.axistoolarge", (Object[])new Object[]{"y", maxAxis, area.getYsize()}), false);
            return coordinates;
        }
        if (area.getZsize() > (double)maxAxis) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.axistoolarge", (Object[])new Object[]{"z", maxAxis, area.getZsize()}), false);
            return coordinates;
        }
        Stream areaStream = BlockPos.betweenClosedStream((AABB)area);
        long size = areaStream.count();
        if (size > (long)(maxSize = 100000)) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.areatoolarge", (Object[])new Object[]{maxSize, size}), false);
            return coordinates;
        }
        BlockPos.betweenClosedStream((AABB)area).map(BlockPos::immutable).forEach(pos -> {
            if (GadgetUtils.isValidBlockState(level.getBlockState(pos), level, pos) && !(level.getBlockState(pos).getBlock() instanceof RenderBlock)) {
                coordinates.add(new StatePos(GadgetUtils.cleanBlockState(level.getBlockState(pos)), pos.subtract((Vec3i)copyStart)));
            } else {
                coordinates.add(new StatePos(Blocks.AIR.defaultBlockState(), pos.subtract((Vec3i)copyStart)));
            }
        });
        return coordinates;
    }
}

