/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core.context;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.init.v1.BuiltinItemRenderer;
import fuzs.puzzleslib.api.client.init.v1.ReloadingBuiltInItemRenderer;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.jetbrains.annotations.Nullable;

public record BuiltinModelItemRendererContextNeoForgeImpl(BiConsumer<IClientItemExtensions, Item> consumer, String modId, List<ResourceManagerReloadListener> dynamicRenderers) implements BuiltinModelItemRendererContext
{
    @Override
    public void registerItemRenderer(BuiltinItemRenderer renderer, ItemLike ... items) {
        if (DatagenModLoader.isRunningDataGen()) {
            return;
        }
        Objects.requireNonNull(renderer, "renderer is null");
        Objects.requireNonNull(items, "items is null");
        Preconditions.checkState((items.length > 0 ? 1 : 0) != 0, (Object)"items is empty");
        ClientItemExtensionsImpl clientItemExtensions = new ClientItemExtensionsImpl(renderer);
        for (ItemLike item : items) {
            Objects.requireNonNull(item, "item is null");
            this.consumer.accept(clientItemExtensions, item.asItem());
        }
    }

    @Override
    public void registerItemRenderer(ReloadingBuiltInItemRenderer renderer, ItemLike ... items) {
        this.registerItemRenderer((BuiltinItemRenderer)renderer, items);
        String itemName = BuiltInRegistries.ITEM.getKey((Object)items[0].asItem()).getPath();
        ResourceLocation resourceLocation = ResourceLocationHelper.fromNamespaceAndPath(this.modId, itemName + "_built_in_model_renderer");
        this.dynamicRenderers.add((ResourceManagerReloadListener)ForwardingReloadListenerHelper.fromResourceManagerReloadListener(resourceLocation, renderer));
    }

    private static class ClientItemExtensionsImpl
    implements IClientItemExtensions {
        private final BuiltinItemRenderer itemRenderer;
        @Nullable
        private BlockEntityWithoutLevelRenderer blockEntityRenderer;

        public ClientItemExtensionsImpl(BuiltinItemRenderer itemRenderer) {
            this.itemRenderer = itemRenderer;
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            if (this.blockEntityRenderer == null) {
                Minecraft minecraft = Minecraft.getInstance();
                this.blockEntityRenderer = new BlockEntityWithoutLevelRenderer(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

                    public void renderByItem(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource buffer, int packedLight, int packedOverlay) {
                        itemRenderer.renderByItem(itemStack, displayContext, matrices, buffer, packedLight, packedOverlay);
                    }
                };
                return this.blockEntityRenderer;
            }
            return this.blockEntityRenderer;
        }
    }
}

