/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import com.mojang.blaze3d.platform.Window;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.GameContext;
import nx.pingwheel.common.core.PingData;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.render.WorldRenderContext;
import nx.pingwheel.common.resource.ResourceConstants;
import nx.pingwheel.common.util.DirectionalSoundInstance;
import org.jetbrains.annotations.Nullable;

public class PingView
extends PingData {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private int spawnTime;
    private int age;
    @Nullable
    private PlayerInfo playerInfo;
    @Nullable
    private ItemStack itemStack;
    private ScreenPos screenPos;
    private double distance;
    private float scale;

    private PingView(Vec3 pos, @Nullable UUID entityId, @Nullable UUID authorId, int sequence, int dimension) {
        super(pos, entityId, authorId, sequence, dimension);
    }

    public static PingView of(Vec3 pos, @Nullable UUID entityId, @Nullable UUID authorId, int sequence, int dimension) {
        return new PingView(pos, entityId, authorId, sequence, dimension);
    }

    public static PingView from(PingLocationS2CPacket packet) {
        return PingView.of(packet.pos(), packet.entity(), packet.author(), packet.sequence(), packet.dimension());
    }

    public void update(WorldRenderContext ctx, int gameTime) {
        Entity ent;
        if (this.spawnTime == 0) {
            this.spawnTime = gameTime;
        }
        this.age = gameTime - this.spawnTime;
        ClientPacketListener connection = CommonClient.Game.getConnection();
        if (connection != null && this.authorId != null) {
            this.playerInfo = connection.getPlayerInfo(this.authorId);
        }
        if (this.entityId != null && (ent = GameContext.getEntity(this.entityId)) != null) {
            if (ent.getType() == EntityType.ITEM && CLIENT_CONFIG.isItemIconVisible()) {
                this.itemStack = ((ItemEntity)ent).getItem().copy();
            }
            this.pos = ent.getPosition(ctx.tickDelta.floatValue()).add(0.0, ent.getBoundingBox().getYsize(), 0.0);
        }
        this.screenPos = MathUtils.worldToScreen(this.pos, ctx.modelViewMatrix, ctx.projectionMatrix);
        this.distance = ctx.camera.getPosition().distanceTo(this.pos);
        this.calculateScale();
    }

    public void playSound() {
        if (this.dimension != GameContext.getDimension()) {
            return;
        }
        CommonClient.Game.getSoundManager().play((SoundInstance)new DirectionalSoundInstance(ResourceConstants.PING_SOUND_EVENT, SoundSource.MASTER, (float)CLIENT_CONFIG.getPingVolume() / 100.0f, 1.0f, this.pos));
    }

    public boolean isExpired() {
        return this.age > CLIENT_CONFIG.getPingDuration() * 20 && CLIENT_CONFIG.getPingDuration() < 60;
    }

    public boolean isRemovable() {
        return (CLIENT_CONFIG.getCorrectionPeriod() >= 5.0f || (float)this.age > CLIENT_CONFIG.getCorrectionPeriod() * 20.0f) && this.distanceToCenter() < (float)CLIENT_CONFIG.getRemoveRadius();
    }

    public float distanceToCenter() {
        if (this.screenPos == null) {
            return 0.0f;
        }
        Window wnd = CommonClient.Game.getWindow();
        Vec2 center = new Vec2((float)wnd.getGuiScaledWidth() * 0.5f, (float)wnd.getGuiScaledHeight() * 0.5f);
        return this.screenPos.distanceTo(center);
    }

    public boolean isCloserToCenter(@Nullable PingView b) {
        if (b == null) {
            return true;
        }
        return this.distanceToCenter() < b.distanceToCenter();
    }

    private void calculateScale() {
        double scale = 2.0 / Math.pow(this.distance, 0.3);
        float pingSize = (float)CLIENT_CONFIG.getPingSize() / 100.0f;
        this.scale = (float)Math.max(1.0, scale) * 0.5f * pingSize;
    }

    @Nullable
    public PlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ScreenPos getScreenPos() {
        return this.screenPos;
    }

    public double getDistance() {
        return this.distance;
    }

    public float getScale() {
        return this.scale;
    }
}

