/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindowBarred
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<WindowState> WINDOWSTATE = EnumProperty.create((String)"windowstate", WindowState.class);
    protected static final VoxelShape EE = WindowBarred.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = WindowBarred.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FIX = WindowBarred.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (double)0.0);

    public WindowBarred(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue(WINDOWSTATE, (Comparable)((Object)WindowState.CLOSED)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        WindowState windowState = (WindowState)((Object)state.getValue(WINDOWSTATE));
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (windowState == WindowState.OPEN_LEFT || windowState == WindowState.OPEN_RIGHT) {
            return FIX;
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return EE;
        }
        return NN;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        WindowState newState;
        Item item = itemstack.getItem();
        WindowState windowState = (WindowState)((Object)state.getValue(WINDOWSTATE));
        if (item == ItemInit.KEY.get()) {
            this.lockWindow(level, pos, windowState != WindowState.LOCKED, (Direction)state.getValue((Property)FACING), 1000);
            level.playSound(null, pos, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
            state = (BlockState)state.setValue(WINDOWSTATE, (Comparable)((Object)(windowState == WindowState.LOCKED ? WindowState.CLOSED : WindowState.LOCKED)));
            level.setBlock(pos, state, 10);
            return ItemInteractionResult.SUCCESS;
        }
        if (windowState == WindowState.LOCKED || item == this.asItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (windowState == WindowState.CLOSED) {
            newState = this.getHingeDirectionFromContext(pos, (Direction)state.getValue((Property)FACING), hit.getLocation());
            this.toggleWindowState(level, pos, newState);
            level.playSound(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
        } else {
            newState = WindowState.CLOSED;
            this.toggleWindowState(level, pos, newState);
            level.playSound(null, pos, (SoundEvent)SoundsInit.WINDOW_CLOSE.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
        }
        state = (BlockState)state.setValue(WINDOWSTATE, (Comparable)((Object)newState));
        level.setBlock(pos, state, 10);
        return ItemInteractionResult.SUCCESS;
    }

    private WindowState getHingeDirectionFromContext(BlockPos blockpos, Direction direction, Vec3 clickLocation) {
        int j = direction.getStepX();
        int k = direction.getStepZ();
        double d0 = clickLocation.x - (double)blockpos.getX();
        double d1 = clickLocation.z - (double)blockpos.getZ();
        boolean left = !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5);
        return left ? WindowState.OPEN_RIGHT : WindowState.OPEN_LEFT;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? NN : EE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WINDOWSTATE});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.updateShape(stateIn, facing, facingState, (LevelAccessor)worldIn, currentPos, facingPos);
    }

    private void toggleWindowState(Level world, BlockPos pos, WindowState newState) {
        BlockState state = world.getBlockState(pos);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (state.getValue(WINDOWSTATE) == newState) {
            return;
        }
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(WINDOWSTATE, (Comparable)((Object)newState)));
        this.toggleAdjacentWindows(world, pos.above(), facing, newState, 0, 100);
        this.toggleAdjacentWindows(world, pos.below(), facing, newState, 0, 100);
    }

    private void toggleAdjacentWindows(Level world, BlockPos pos, Direction facing, WindowState newState, int depth, int maxDepth) {
        BlockState state = world.getBlockState(pos);
        if (depth > maxDepth || state.getBlock() != this || state.getValue((Property)FACING) != facing) {
            return;
        }
        if (state.getValue(WINDOWSTATE) != newState) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(WINDOWSTATE, (Comparable)((Object)newState)));
            this.toggleAdjacentWindows(world, pos.above(), facing, newState, depth + 1, maxDepth);
            this.toggleAdjacentWindows(world, pos.below(), facing, newState, depth + 1, maxDepth);
        }
    }

    private void lockWindow(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() == this) {
            boolean isLocked = state.getValue(WINDOWSTATE) == WindowState.LOCKED;
            Direction direction = (Direction)state.getValue((Property)FACING);
            if (isLocked != targetOpen && direction.equals((Object)targetDirection)) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(WINDOWSTATE, (Comparable)((Object)(targetOpen ? WindowState.LOCKED : WindowState.CLOSED))));
                Direction[] directions = direction.getAxis() == Direction.Axis.X ? new Direction[]{Direction.SOUTH, Direction.NORTH} : new Direction[]{Direction.EAST, Direction.WEST};
                for (Direction dir : directions) {
                    this.lockWindow(world, pos.relative(dir), targetOpen, targetDirection, depth - 2);
                }
                for (int y = 1; y <= 2; ++y) {
                    this.lockWindow(world, pos.above(y), targetOpen, targetDirection, depth - 2);
                    this.lockWindow(world, pos.below(y), targetOpen, targetDirection, depth - 2);
                }
            }
        }
    }

    public static enum WindowState implements StringRepresentable
    {
        CLOSED("closed"),
        OPEN_LEFT("open_left"),
        OPEN_RIGHT("open_right"),
        LOCKED("locked");

        private final String name;

        private WindowState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

