/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.snowballsfreezemobs_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.snowballsfreezemobs_common_neoforge.config.ConfigHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SnowEvent {
    private static final Map<LivingEntity, Vec3> hitentities = new HashMap<LivingEntity, Vec3>();

    public static float onEntityHurt(Level world, Entity entity, DamageSource damageSource, float damageAmount) {
        if (world.isClientSide) {
            return damageAmount;
        }
        if (!(damageSource.getDirectEntity() instanceof Snowball)) {
            return damageAmount;
        }
        if (entity instanceof Player) {
            return damageAmount;
        }
        EntityFunctions.addPotionEffect((Entity)entity, (Holder)MobEffects.BLINDNESS, (Integer)ConfigHandler.freezeTimeMs);
        hitentities.put((LivingEntity)entity, entity.position());
        return 0.0f;
    }

    public static void onLivingUpdate(Level world, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        if (le.getEffect(MobEffects.BLINDNESS) != null) {
            if (hitentities.containsKey(le)) {
                Vec3 lastvec = hitentities.get(le);
                le.teleportTo(lastvec.x, le.getY(), lastvec.z);
            }
        } else if (hitentities.containsKey(le)) {
            hitentities.remove(le);
        }
    }
}

