/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.cursedness.HorizontalPortalShape;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BaseFireBlock.class})
public abstract class BaseFireBlockMixin {
    @ModifyVariable(method={"isPortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Direction;values()[Lnet/minecraft/core/Direction;"), ordinal=0)
    private static boolean allowCryingObsidianForPortal(boolean flag, Level level, BlockPos pos, Direction direction) {
        if (flag) {
            return true;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction searchDirection : Direction.values()) {
            if (!level.getBlockState((BlockPos)mutablePos.set((Vec3i)pos).move(searchDirection)).is(Blocks.CRYING_OBSIDIAN)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"onPlace"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canSurvive(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z")}, cancellable=true)
    private void checkHorizontalPortal(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving, CallbackInfo ci) {
        Optional<HorizontalPortalShape> horizontal;
        if (BaseFireBlockMixin.inPortalDimension(level) && (horizontal = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, pos)).isPresent()) {
            horizontal.get().createPortalBlocks();
            ci.cancel();
        }
    }

    private static boolean inPortalDimension(Level level) {
        return level.dimension() == Level.OVERWORLD || level.dimension() == Level.NETHER;
    }
}

