/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.utils.HashSetQueue;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PortalShape.class})
public abstract class PortalShapeMixin {
    @Unique
    private boolean customShapes$valid = false;
    @Unique
    HashSet<BlockPos> customShapes$validPortalPositions = new HashSet();
    @Unique
    int customShapes$portalBlockCount = 0;
    @Final
    @Shadow
    private LevelAccessor level;
    @Final
    @Shadow
    private Direction rightDir;
    @Final
    @Shadow
    private Direction.Axis axis;

    @Inject(method={"isEmpty"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isEmpty(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (state.is(Blocks.CRYING_OBSIDIAN)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void constructor(LevelAccessor level, BlockPos startPos, Direction.Axis axis, CallbackInfo ci) {
        this.customShapes$valid = this.customShapes$checkAreaForPortalValidity(startPos, axis);
    }

    @Unique
    private boolean customShapes$checkAreaForPortalValidity(BlockPos startPos, Direction.Axis axis) {
        this.customShapes$validPortalPositions.clear();
        HashSet<BlockPos> validFrameBlocks = new HashSet<BlockPos>();
        HashSetQueue<BlockPos> positionsToCheck = new HashSetQueue<BlockPos>();
        boolean minSizeFound = true;
        List<Direction> directions = List.of(Direction.DOWN, Direction.UP, this.rightDir.getOpposite(), this.rightDir);
        positionsToCheck.push(startPos);
        while (!positionsToCheck.isEmpty()) {
            BlockPos pos = (BlockPos)positionsToCheck.pop();
            if (this.customShapes$validPortalPositions.contains(pos) || validFrameBlocks.contains(pos)) continue;
            boolean isOrCanBePortal = this.customShapes$isValidPosForPortalBlock(pos);
            boolean isFrameBlock = this.customShapes$isValidFrameBlock(pos);
            if (!isOrCanBePortal && !isFrameBlock) {
                return false;
            }
            if (isOrCanBePortal) {
                this.customShapes$validPortalPositions.add(pos);
                if (this.customShapes$validPortalPositions.size() > 1000) {
                    return false;
                }
                if (this.level.getBlockState(pos).is(Blocks.NETHER_PORTAL)) {
                    ++this.customShapes$portalBlockCount;
                }
                if (!minSizeFound && (this.customShapes$validPortalPositions.contains(pos.above()) || this.customShapes$validPortalPositions.contains(pos.below()))) {
                    minSizeFound = true;
                }
                directions.forEach(direction -> {
                    BlockPos neighborPos = pos.relative(direction);
                    if (!this.customShapes$validPortalPositions.contains(neighborPos) && !validFrameBlocks.contains(neighborPos)) {
                        positionsToCheck.push(neighborPos);
                    }
                });
                continue;
            }
            validFrameBlocks.add(pos);
        }
        return minSizeFound;
    }

    @Unique
    private boolean customShapes$isValidPosForPortalBlock(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        return (state.isAir() || state.is(Blocks.FIRE) || state.is(Blocks.NETHER_PORTAL) || state.is(Blocks.CRYING_OBSIDIAN)) && !this.level.isOutsideBuildHeight(pos);
    }

    @Unique
    private boolean customShapes$isValidFrameBlock(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        return (state.is(Blocks.OBSIDIAN) || state.is(Blocks.CRYING_OBSIDIAN)) && !this.level.isOutsideBuildHeight(pos);
    }

    @Inject(method={"createPortalBlocks"}, at={@At(value="HEAD")}, cancellable=true)
    private void createPortal(CallbackInfo ci) {
        BlockState blockState = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)this.axis);
        this.customShapes$validPortalPositions.forEach(pos -> this.level.setBlock(pos, blockState, 18));
        ci.cancel();
    }

    @Inject(method={"isValid"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValid(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)this.customShapes$valid);
    }

    @Inject(method={"isComplete"}, at={@At(value="HEAD")}, cancellable=true)
    private void isComplete(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(this.customShapes$valid && this.customShapes$validPortalPositions.size() == this.customShapes$portalBlockCount ? 1 : 0));
    }
}

