/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.init.ModStructureTypes;

public class Dungeon
extends Structure {
    public static final GenerationStep.Decoration GENERATION_STEP = GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    public static final MapCodec<Structure> CODEC = Dungeon.simpleCodec(Dungeon::new);
    private static final int BIOME_CHECK_RADIUS = 1;

    public Dungeon(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int centerX = context.chunkPos().getBlockX(7);
        int centerZ = context.chunkPos().getBlockZ(7);
        int centerHeight = context.chunkGenerator().getFirstOccupiedHeight(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        if (Dungeon.isInvalidSpot(context, 1)) {
            return Optional.empty();
        }
        int minGroundHeight = Dungeon.minHeight(context, centerX, centerZ, centerHeight);
        if (minGroundHeight < 45) {
            return Optional.empty();
        }
        int startHeight = (Boolean)Config.FIXED_GENERATION_HEIGHT.get() != false ? context.chunkGenerator().getSpawnHeight(context.heightAccessor()) - 20 : (minGroundHeight > 80 ? 80 + (minGroundHeight - 80) / 3 : minGroundHeight) - 20;
        BlockPos position = new BlockPos(centerX, centerHeight, centerZ);
        return Optional.of(new Structure.GenerationStub(position, structurePiecesBuilder -> this.generatePieces((StructurePiecesBuilder)structurePiecesBuilder, context, position, startHeight)));
    }

    private void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context, BlockPos position, int startHeight) {
        DungeonBuilder builder = new DungeonBuilder(context, startHeight, position);
        builder.build().forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).addPiece(arg_0));
    }

    public StructureType<?> type() {
        return ModStructureTypes.dungeon();
    }

    private static boolean isInvalidSpot(Structure.GenerationContext context, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkPos pos = new ChunkPos(context.chunkPos().x + x, context.chunkPos().z + z);
                int centerX = QuartPos.fromBlock((int)pos.getBlockX(7));
                int centerZ = QuartPos.fromBlock((int)pos.getBlockZ(7));
                Holder centerBiome = context.chunkGenerator().getBiomeSource().getNoiseBiome(centerX, context.chunkGenerator().getFirstOccupiedHeight(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()), centerZ, context.randomState().sampler());
                if (context.validBiome().test(centerBiome)) continue;
                return true;
            }
        }
        return false;
    }

    private static int minHeight(Structure.GenerationContext context, int centerX, int centerZ, int centerHeight) {
        int minHeight = centerHeight;
        for (int i = 1; i < 9; ++i) {
            int size = i * 5;
            minHeight = Math.min(minHeight, Dungeon.lowestCornerHeight(context, centerX - size, size << 1, centerZ - size, size << 1));
        }
        return minHeight;
    }

    private static int lowestCornerHeight(Structure.GenerationContext context, int x, int sizeX, int z, int sizeZ) {
        int height = context.chunkGenerator().getFirstFreeHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        height = Math.min(height, context.chunkGenerator().getFirstFreeHeight(x + sizeX, z, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()));
        height = Math.min(height, context.chunkGenerator().getFirstFreeHeight(x, z + sizeZ, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()));
        height = Math.min(height, context.chunkGenerator().getFirstFreeHeight(x + sizeX, z + sizeZ, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()));
        return height;
    }

    public GenerationStep.Decoration step() {
        return GENERATION_STEP;
    }
}

