/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.time_on_display;

import com.cursee.monolib.core.sailing.Sailing;
import java.lang.reflect.Field;
import neoforge.com.cursee.time_on_display.Constants;
import neoforge.com.cursee.time_on_display.TimeOnDisplay;
import neoforge.com.cursee.time_on_display.core.TimeOnDisplayConfig;
import neoforge.com.cursee.time_on_display.core.TimeOnDisplayKeyBindNeoForge;
import neoforge.com.cursee.time_on_display.core.TimeOnDisplayOverlayNeoForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.LayeredDraw;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@Mod(value="time_on_display")
public class TimeOnDisplayNeoForge {
    public static boolean displayToggle = false;

    public TimeOnDisplayNeoForge(IEventBus bus) {
        TimeOnDisplay.init();
        Sailing.register((String)"Time On Display", (String)"time_on_display", (String)"2.0.0", (String)"[1.21]", Constants.PUBLISHER_AUTHOR, Constants.PRIMARY_CURSEFORGE_MODRINTH);
        TimeOnDisplayConfig.initialize();
    }

    @EventBusSubscriber(modid="time_on_display", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class ClientForgeBusEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (TimeOnDisplayKeyBindNeoForge.TIMEONDISPLAY_KEY.consumeClick() && Minecraft.getInstance().player != null) {
                displayToggle = !displayToggle;
            }
        }
    }

    @EventBusSubscriber(modid="time_on_display", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        private static final Field LAYERS = ObfuscationReflectionHelper.findField(Gui.class, (String)"layers");

        @SubscribeEvent
        public static void clientInit(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                try {
                    LayeredDraw layers = (LayeredDraw)LAYERS.get(mc.gui);
                    layers.add((LayeredDraw.Layer)new TimeOnDisplayOverlayNeoForge());
                }
                catch (IllegalAccessException e) {
                    System.out.println(e.getMessage());
                }
            });
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(TimeOnDisplayKeyBindNeoForge.TIMEONDISPLAY_KEY);
        }
    }
}

