/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen;

import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseWiringHelper
implements DensityFunction.Visitor {
    private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
    private final boolean useLegacySource;
    private final long seed;
    final RandomState randomState;
    final PositionalRandomFactory random;

    public NoiseWiringHelper(PlacementCondition.Context context, NoiseGeneratorSettings settings) {
        this(context.seed(), settings.useLegacyRandomSource(), context.randomState(), ((RandomStateAccessor)context.randomState()).getRandom());
    }

    public NoiseWiringHelper(long seed, boolean useLegacySource, RandomState randomState, PositionalRandomFactory random) {
        this.seed = seed;
        this.useLegacySource = useLegacySource;
        this.randomState = randomState;
        this.random = random;
    }

    public DensityFunction.NoiseHolder visitNoise(DensityFunction.NoiseHolder noiseHolder) {
        Holder noiseData = noiseHolder.noiseData();
        if (this.useLegacySource) {
            if (noiseData.is(Noises.TEMPERATURE)) {
                NormalNoise noise = NormalNoise.createLegacyNetherBiome((RandomSource)this.newLegacyInstance(0L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                return new DensityFunction.NoiseHolder(noiseData, noise);
            }
            if (noiseData.is(Noises.VEGETATION)) {
                NormalNoise noise = NormalNoise.createLegacyNetherBiome((RandomSource)this.newLegacyInstance(1L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                return new DensityFunction.NoiseHolder(noiseData, noise);
            }
            if (noiseData.is(Noises.SHIFT)) {
                NormalNoise noise = NormalNoise.create((RandomSource)this.random.fromHashOf(Noises.SHIFT.location()), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(0, 0.0, new double[0]));
                return new DensityFunction.NoiseHolder(noiseData, noise);
            }
        }
        NormalNoise noise = this.randomState.getOrCreateNoise((ResourceKey)noiseData.unwrapKey().orElseThrow());
        return new DensityFunction.NoiseHolder(noiseData, noise);
    }

    public DensityFunction apply(DensityFunction densityFunction) {
        return this.wrapped.computeIfAbsent(densityFunction, this::wrapNew);
    }

    private DensityFunction wrapNew(DensityFunction densityFunction) {
        if (densityFunction instanceof BlendedNoise) {
            BlendedNoise noise = (BlendedNoise)densityFunction;
            RandomSource random = this.useLegacySource ? this.newLegacyInstance(0L) : this.random.fromHashOf(ResourceLocation.withDefaultNamespace((String)"terrain"));
            return noise.withNewRandom(random);
        }
        return densityFunction instanceof DensityFunctions.EndIslandDensityFunction ? new DensityFunctions.EndIslandDensityFunction(this.seed) : densityFunction;
    }

    private RandomSource newLegacyInstance(long noiseSeed) {
        return new LegacyRandomSource(this.seed + noiseSeed);
    }
}

