/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.util.weighted.WeightedList;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.stateprovider.WeightedProvider;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public record DungeonConfig(int minOpenings, int maxOpenings, IntProvider radius, int maxChests, WeightedList<EntityType<?>> spawnerMobs, BlockStateProvider floorProvider, BlockStateProvider wallProvider, Optional<HolderSet<Block>> dungeonInvalidBlocks, ResourceKey<LootTable> lootTable) implements FeatureConfiguration
{
    private static final WeightedList<EntityType<?>> DEFAULT_MOBS = WeightedList.builder().add(EntityType.ZOMBIE, 2).add(EntityType.SKELETON, 1).add(EntityType.SPIDER, 1).build();
    private static final WeightedList<BlockStateProvider> DEFAULT_FLOOR = WeightedList.builder().add(SimpleStateProvider.simple((Block)Blocks.MOSSY_COBBLESTONE), 3).add(SimpleStateProvider.simple((Block)Blocks.COBBLESTONE), 1).build();
    public static final Codec<DungeonConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("min_openings").orElse((Object)1).forGetter(DungeonConfig::minOpenings), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_openings").orElse((Object)5).forGetter(DungeonConfig::maxOpenings), (App)IntProvider.codec((int)1, (int)16).fieldOf("radius").orElse((Object)UniformInt.of((int)2, (int)3)).forGetter(DungeonConfig::radius), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_chests").orElse((Object)2).forGetter(DungeonConfig::maxChests), (App)WeightedList.codec(BuiltInRegistries.ENTITY_TYPE.byNameCodec()).fieldOf("spawner_entity").orElse(DEFAULT_MOBS).forGetter(DungeonConfig::spawnerMobs), (App)BlockStateProvider.CODEC.fieldOf("floor_provider").orElse((Object)new WeightedProvider(DEFAULT_FLOOR)).forGetter(DungeonConfig::floorProvider), (App)BlockStateProvider.CODEC.fieldOf("wall_provider").orElse((Object)SimpleStateProvider.simple((Block)Blocks.COBBLESTONE)).forGetter(DungeonConfig::wallProvider), (App)LithostitchedCodecs.BLOCK_SET.optionalFieldOf("dungeon_invalid_blocks").forGetter(DungeonConfig::dungeonInvalidBlocks), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").orElse((Object)BuiltInLootTables.SIMPLE_DUNGEON).forGetter(DungeonConfig::lootTable)).apply((Applicative)instance, DungeonConfig::new));
}

