/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Matrix4f;

public class ClientUtil {
    public static void colorBlit(PoseStack pMatrixStack, float pX, float pY, float pUOffset, float pVOffset, float pUWidth, float pVHeight, int color) {
        ClientUtil.innerBlit(pMatrixStack, pX, pX + pUWidth, pY, pY + pVHeight, 0, pUWidth, pVHeight, pUOffset, pVOffset, 256, 256, color);
    }

    public static void colorBlit(PoseStack pMatrixStack, int pX, int pY, int pBlitOffset, int pWidth, int pHeight, TextureAtlasSprite pSprite, int color) {
        ClientUtil.innerBlit(pMatrixStack.last().pose(), pX, pX + pWidth, pY, pY + pHeight, pBlitOffset, pSprite.getU0(), pSprite.getU1(), pSprite.getV0(), pSprite.getV1(), color);
    }

    public static void colorBlit(PoseStack pPoseStack, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight, int color) {
        ClientUtil.innerBlit(pPoseStack, pX, pX + pWidth, pY, pY + pHeight, 0, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight, color);
    }

    public static void innerBlit(PoseStack pMatrixStack, float pX1, float pX2, float pY1, float pY2, int pBlitOffset, float pUWidth, float pVHeight, float pUOffset, float pVOffset, int pTextureWidth, int pTextureHeight, int color) {
        ClientUtil.innerBlit(pMatrixStack.last().pose(), pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / (float)pTextureWidth, (pUOffset + pUWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight, (pVOffset + pVHeight) / (float)pTextureHeight, color);
    }

    public static void innerBlit(Matrix4f pMatrix, float pX1, float pX2, float pY1, float pY2, int pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, int color) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (a == 0) {
            a = 255;
        }
        bufferbuilder.addVertex(pMatrix, pX1, pY2, (float)pBlitOffset).setUv(pMinU, pMaxV).setColor(r, g, b, a);
        bufferbuilder.addVertex(pMatrix, pX2, pY2, (float)pBlitOffset).setUv(pMaxU, pMaxV).setColor(r, g, b, a);
        bufferbuilder.addVertex(pMatrix, pX2, pY1, (float)pBlitOffset).setUv(pMaxU, pMinV).setColor(r, g, b, a);
        bufferbuilder.addVertex(pMatrix, pX1, pY1, (float)pBlitOffset).setUv(pMinU, pMinV).setColor(r, g, b, a);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

