/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.spyglass_improvements.client.integrations;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public interface IEquipmentIntegration {
    public boolean isPlayerUsingSpyglass(Player var1);

    public void registerRenderer();

    default public void render(ItemStack stack, LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        BakedModel spyglassModel = itemRenderer.getModel(Items.SPYGLASS.getDefaultInstance(), (Level)mc.level, (LivingEntity)mc.player, 1);
        poseStack.pushPose();
        if (livingEntity.isCrouching()) {
            poseStack.translate(0.0f, 0.15f, 0.32f);
        }
        poseStack.translate(0.16, 0.6, 0.16);
        poseStack.mulPose(Direction.DOWN.getRotation());
        poseStack.scale(0.7f, 0.7f, 0.7f);
        itemRenderer.render(stack, ItemDisplayContext.NONE, true, poseStack, renderTypeBuffer, light, OverlayTexture.NO_OVERLAY, spyglassModel);
        poseStack.popPose();
    }
}

