/*
 * Decompiled with CFR 0.152.
 */
package net.palegarden.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.palegarden.entity.CreakingEntity;
import net.palegarden.entity.CreakingHeartEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PalegardenModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"palegarden");
    public static final DeferredHolder<EntityType<?>, EntityType<CreakingEntity>> CREAKING = PalegardenModEntities.register("creaking", EntityType.Builder.of(CreakingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(80).setUpdateInterval(3).sized(0.9f, 2.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<CreakingHeartEntity>> CREAKING_HEART = PalegardenModEntities.register("creaking_heart", EntityType.Builder.of(CreakingHeartEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        CreakingEntity.init(event);
        CreakingHeartEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CREAKING.get(), CreakingEntity.createAttributes().build());
        event.put((EntityType)CREAKING_HEART.get(), CreakingHeartEntity.createAttributes().build());
    }
}

