/*
 * Decompiled with CFR 0.152.
 */
package net.palegarden.procedures;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.palegarden.entity.CreakingEntity;
import net.palegarden.init.PalegardenModBlocks;
import net.palegarden.init.PalegardenModParticleTypes;

@EventBusSubscriber
public class CreakingEntityIsHurtProcedure {
    @SubscribeEvent
    public static void onEntityAttacked(LivingIncomingDamageEvent event) {
        if (event.getEntity() != null) {
            CreakingEntityIsHurtProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (Entity)event.getEntity());
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        CreakingEntityIsHurtProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        double x_closest = 0.0;
        double y_closest = 0.0;
        double z_closest = 0.0;
        boolean found = false;
        if (entity instanceof CreakingEntity) {
            ((CreakingEntity)entity).setAnimation("animation.creaking.shake");
            if (event instanceof ICancellableEvent) {
                ICancellableEvent _cancellable = (ICancellableEvent)event;
                _cancellable.setCanceled(true);
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)PalegardenModParticleTypes.CREAKING_CONNECTION_1.get()), x, y + 1.0, z, 15, 0.2, 0.2, 0.2, 0.01);
            }
            int horizontalRadiusSquare = 99;
            int verticalRadiusSquare = 39;
            for (int i = -verticalRadiusSquare; i <= verticalRadiusSquare; ++i) {
                for (int xi = -horizontalRadiusSquare; xi <= horizontalRadiusSquare; ++xi) {
                    for (int zi = -horizontalRadiusSquare; zi <= horizontalRadiusSquare; ++zi) {
                        BlockPos blockPos = BlockPos.containing((double)(x + (double)xi), (double)(y + (double)i), (double)(z + (double)zi));
                        if (found || world.getBlockState(blockPos).getBlock() != PalegardenModBlocks.CREAKING_HEART.get()) continue;
                        found = true;
                        x_closest = x + (double)xi;
                        double dx = x_closest - x;
                        y_closest = y + (double)i;
                        double dy = y_closest - y;
                        z_closest = z + (double)zi;
                        double dz = z_closest - z;
                        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        if (distance == 0.0) continue;
                        double dirX = dx / distance;
                        double dirY = dy / distance;
                        double dirZ = dz / distance;
                        for (int j = 1; j <= 4; ++j) {
                            SimpleParticleType particleType;
                            double particleX = x + dirX * (double)j;
                            double particleY = y + dirY * (double)j + 1.0;
                            double particleZ = z + dirZ * (double)j;
                            SimpleParticleType simpleParticleType = particleType = j % 2 == 0 ? (SimpleParticleType)PalegardenModParticleTypes.CREAKING_CONNECTION_1.get() : (SimpleParticleType)PalegardenModParticleTypes.CREAKING_CONNECT_2.get();
                            if (!(world instanceof ServerLevel)) continue;
                            ServerLevel particleLevel = (ServerLevel)world;
                            particleLevel.sendParticles((ParticleOptions)particleType, particleX, particleY, particleZ, 10, 0.1, 0.1, 0.1, 0.01);
                        }
                    }
                }
            }
            if (!found) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.playSound(null, entity.blockPosition(), SoundEvents.SHULKER_BULLET_HIT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                entity.discard();
            }
        }
    }
}

