/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class SunnyMilkModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private float ticks;
    private ModelPart wingRight;
    private ModelPart wingLeft;

    public SunnyMilkModel(LayerDefinition definition) {
        ModelPart root = definition.bakeRoot();
        this.wingLeft = root.getChild("wingLeft");
        this.wingRight = root.getChild("wingRight");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        CubeListBuilder wingLeft = CubeListBuilder.create();
        wingLeft.texOffs(0, 12).addBox(0.5f, -5.5f, 0.0f, 0.0f, 12.0f, 20.0f);
        wingLeft.texOffs(0, 28).addBox(0.5f, 6.5f, 0.0f, 0.0f, 10.0f, 16.0f);
        CubeListBuilder wingRight = CubeListBuilder.create();
        wingRight.texOffs(0, 12).addBox(-0.5f, -5.5f, 0.0f, 0.0f, 12.0f, 20.0f);
        wingRight.texOffs(0, 28).addBox(-0.5f, 6.5f, 0.0f, 0.0f, 10.0f, 16.0f);
        root.addOrReplaceChild("wingLeft", wingLeft, PartPose.offset((float)-1.9641f, (float)-2.0f, (float)2.0f));
        root.addOrReplaceChild("wingRight", wingRight, PartPose.offset((float)1.9641f, (float)-2.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.wingLeft, (Object)this.wingRight);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float netHeadYaw, float headPitch) {
        float f = (float)entityIn.getDeltaMovement().length() * 10.0f;
        this.ticks += Minecraft.getInstance().getTimer().getGameTimeDeltaTicks() * (1.0f + Math.min(9.0f, f * f * f)) * 0.1f;
        this.wingLeft.yRot = -1.0472f + Mth.sin((float)this.ticks) * 0.25f;
        this.wingRight.yRot = -this.wingLeft.yRot;
    }
}

