/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;

public interface KBlockUtils {
    public static final Interner<Property<?>> PROPERTY_INTERNER = Interners.newStrongInterner();
    public static final BiMap<String, Property<?>> COMMON_PROPERTIES = KBlockUtils.generateCommonProperties();

    public static BiMap<String, Property<?>> generateCommonProperties() {
        ImmutableBiMap.Builder map = ImmutableBiMap.builder();
        map.put((Object)"attached", (Object)BlockStateProperties.ATTACHED);
        map.put((Object)"bottom", (Object)BlockStateProperties.BOTTOM);
        map.put((Object)"conditional", (Object)BlockStateProperties.CONDITIONAL);
        map.put((Object)"disarmed", (Object)BlockStateProperties.DISARMED);
        map.put((Object)"drag", (Object)BlockStateProperties.DRAG);
        map.put((Object)"enabled", (Object)BlockStateProperties.ENABLED);
        map.put((Object)"extended", (Object)BlockStateProperties.EXTENDED);
        map.put((Object)"eye", (Object)BlockStateProperties.EYE);
        map.put((Object)"falling", (Object)BlockStateProperties.FALLING);
        map.put((Object)"hanging", (Object)BlockStateProperties.HANGING);
        map.put((Object)"has_record", (Object)BlockStateProperties.HAS_RECORD);
        map.put((Object)"has_book", (Object)BlockStateProperties.HAS_BOOK);
        map.put((Object)"inverted", (Object)BlockStateProperties.INVERTED);
        map.put((Object)"in_wall", (Object)BlockStateProperties.IN_WALL);
        map.put((Object)"lit", (Object)BlockStateProperties.LIT);
        map.put((Object)"locked", (Object)BlockStateProperties.LOCKED);
        map.put((Object)"occupied", (Object)BlockStateProperties.OCCUPIED);
        map.put((Object)"open", (Object)BlockStateProperties.OPEN);
        map.put((Object)"persistent", (Object)BlockStateProperties.PERSISTENT);
        map.put((Object)"powered", (Object)BlockStateProperties.POWERED);
        map.put((Object)"short", (Object)BlockStateProperties.SHORT);
        map.put((Object)"signal_fire", (Object)BlockStateProperties.SIGNAL_FIRE);
        map.put((Object)"snowy", (Object)BlockStateProperties.SNOWY);
        map.put((Object)"triggered", (Object)BlockStateProperties.TRIGGERED);
        map.put((Object)"unstable", (Object)BlockStateProperties.UNSTABLE);
        map.put((Object)"waterlogged", (Object)BlockStateProperties.WATERLOGGED);
        map.put((Object)"berries", (Object)BlockStateProperties.BERRIES);
        map.put((Object)"bloom", (Object)BlockStateProperties.BLOOM);
        map.put((Object)"shrieking", (Object)BlockStateProperties.SHRIEKING);
        map.put((Object)"can_summon", (Object)BlockStateProperties.CAN_SUMMON);
        map.put((Object)"horizontal_axis", (Object)BlockStateProperties.HORIZONTAL_AXIS);
        map.put((Object)"axis", (Object)BlockStateProperties.AXIS);
        map.put((Object)"up", (Object)BlockStateProperties.UP);
        map.put((Object)"down", (Object)BlockStateProperties.DOWN);
        map.put((Object)"north", (Object)BlockStateProperties.NORTH);
        map.put((Object)"east", (Object)BlockStateProperties.EAST);
        map.put((Object)"south", (Object)BlockStateProperties.SOUTH);
        map.put((Object)"west", (Object)BlockStateProperties.WEST);
        map.put((Object)"facing", (Object)BlockStateProperties.FACING);
        map.put((Object)"facing_hopper", (Object)BlockStateProperties.FACING_HOPPER);
        map.put((Object)"horizontal_facing", (Object)BlockStateProperties.HORIZONTAL_FACING);
        map.put((Object)"flower_amount", (Object)BlockStateProperties.FLOWER_AMOUNT);
        map.put((Object)"orientation", (Object)BlockStateProperties.ORIENTATION);
        map.put((Object)"attach_face", (Object)BlockStateProperties.ATTACH_FACE);
        map.put((Object)"bell_attachment", (Object)BlockStateProperties.BELL_ATTACHMENT);
        map.put((Object)"east_wall", (Object)BlockStateProperties.EAST_WALL);
        map.put((Object)"north_wall", (Object)BlockStateProperties.NORTH_WALL);
        map.put((Object)"south_wall", (Object)BlockStateProperties.SOUTH_WALL);
        map.put((Object)"west_wall", (Object)BlockStateProperties.WEST_WALL);
        map.put((Object)"east_redstone", (Object)BlockStateProperties.EAST_REDSTONE);
        map.put((Object)"north_redstone", (Object)BlockStateProperties.NORTH_REDSTONE);
        map.put((Object)"south_redstone", (Object)BlockStateProperties.SOUTH_REDSTONE);
        map.put((Object)"west_redstone", (Object)BlockStateProperties.WEST_REDSTONE);
        map.put((Object)"double_block_half", (Object)BlockStateProperties.DOUBLE_BLOCK_HALF);
        map.put((Object)"half", (Object)BlockStateProperties.HALF);
        map.put((Object)"rail_shape", (Object)BlockStateProperties.RAIL_SHAPE);
        map.put((Object)"rail_shape_straight", (Object)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
        map.put((Object)"age_1", (Object)BlockStateProperties.AGE_1);
        map.put((Object)"age_2", (Object)BlockStateProperties.AGE_2);
        map.put((Object)"age_3", (Object)BlockStateProperties.AGE_3);
        map.put((Object)"age_4", (Object)BlockStateProperties.AGE_4);
        map.put((Object)"age_5", (Object)BlockStateProperties.AGE_5);
        map.put((Object)"age_7", (Object)BlockStateProperties.AGE_7);
        map.put((Object)"age_15", (Object)BlockStateProperties.AGE_15);
        map.put((Object)"age_25", (Object)BlockStateProperties.AGE_25);
        map.put((Object)"bites", (Object)BlockStateProperties.BITES);
        map.put((Object)"candles", (Object)BlockStateProperties.CANDLES);
        map.put((Object)"delay", (Object)BlockStateProperties.DELAY);
        map.put((Object)"distance", (Object)BlockStateProperties.DISTANCE);
        map.put((Object)"eggs", (Object)BlockStateProperties.EGGS);
        map.put((Object)"hatch", (Object)BlockStateProperties.HATCH);
        map.put((Object)"layers", (Object)BlockStateProperties.LAYERS);
        map.put((Object)"level_cauldron", (Object)BlockStateProperties.LEVEL_CAULDRON);
        map.put((Object)"level_composter", (Object)BlockStateProperties.LEVEL_COMPOSTER);
        map.put((Object)"level_flowing", (Object)BlockStateProperties.LEVEL_FLOWING);
        map.put((Object)"level_honey", (Object)BlockStateProperties.LEVEL_HONEY);
        map.put((Object)"level", (Object)BlockStateProperties.LEVEL);
        map.put((Object)"moisture", (Object)BlockStateProperties.MOISTURE);
        map.put((Object)"note", (Object)BlockStateProperties.NOTE);
        map.put((Object)"pickles", (Object)BlockStateProperties.PICKLES);
        map.put((Object)"power", (Object)BlockStateProperties.POWER);
        map.put((Object)"stage", (Object)BlockStateProperties.STAGE);
        map.put((Object)"stability_distance", (Object)BlockStateProperties.STABILITY_DISTANCE);
        map.put((Object)"rotation_16", (Object)BlockStateProperties.ROTATION_16);
        map.put((Object)"bed_part", (Object)BlockStateProperties.BED_PART);
        map.put((Object)"chest_type", (Object)BlockStateProperties.CHEST_TYPE);
        map.put((Object)"mode_comparator", (Object)BlockStateProperties.MODE_COMPARATOR);
        map.put((Object)"door_hinge", (Object)BlockStateProperties.DOOR_HINGE);
        map.put((Object)"piston_type", (Object)BlockStateProperties.PISTON_TYPE);
        map.put((Object)"slab_type", (Object)BlockStateProperties.SLAB_TYPE);
        map.put((Object)"stairs_shape", (Object)BlockStateProperties.STAIRS_SHAPE);
        map.put((Object)"bamboo_leaves", (Object)BlockStateProperties.BAMBOO_LEAVES);
        map.put((Object)"tilt", (Object)BlockStateProperties.TILT);
        map.put((Object)"vertical_direction", (Object)BlockStateProperties.VERTICAL_DIRECTION);
        map.put((Object)"dripstone_thickness", (Object)BlockStateProperties.DRIPSTONE_THICKNESS);
        map.put((Object)"sculk_sensor_phase", (Object)BlockStateProperties.SCULK_SENSOR_PHASE);
        map.put((Object)"dusted", (Object)BlockStateProperties.DUSTED);
        map.put((Object)"cracked", (Object)BlockStateProperties.CRACKED);
        return map.build();
    }

    public static <T extends Property<?>> T internProperty(T property) {
        return (T)((Property)PROPERTY_INTERNER.intern(property));
    }

    public static Property<?> getProperty(BlockState blockState, String key) {
        Property property = blockState.getBlock().getStateDefinition().getProperty(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return property;
    }

    public static <T extends Comparable<T>> String getValueString(BlockState blockState, String key) {
        Property property = blockState.getBlock().getStateDefinition().getProperty(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return property.getName(blockState.getValue(property));
    }

    public static <T extends Comparable<T>> BlockState setValueByString(BlockState blockState, String key, String value) {
        Property property = blockState.getBlock().getStateDefinition().getProperty(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return (BlockState)blockState.setValue(property, (Comparable)property.getValue(value).orElseThrow());
    }

    public static <T extends Comparable<T>> String getNameByValue(Property<T> property, Object value) {
        return property.getName((Comparable)value);
    }

    @Nullable
    default public BlockState componentsUpdateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        KBlockSettings settings = KBlockSettings.of(this);
        if (settings == null) {
            return pState;
        }
        return settings.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    default public BlockState componentsGetStateForPlacement(BlockState pState, BlockPlaceContext pContext) {
        KBlockSettings settings = KBlockSettings.of(this);
        if (settings == null) {
            return pState;
        }
        return settings.getStateForPlacement(pState, pContext);
    }
}

