/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.duck.KPlayer;
import snownee.kiwi.network.KPacketSender;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PayloadContext;
import snownee.kiwi.network.PlayPacketHandler;

@KiwiPacket
public record SSyncPlaceCountPacket(int placeCount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SSyncPlaceCountPacket> TYPE = new CustomPacketPayload.Type(Kiwi.id("sync_place_count"));

    public CustomPacketPayload.Type<SSyncPlaceCountPacket> type() {
        return TYPE;
    }

    public static void sync(ServerPlayer player) {
        KPacketSender.send((CustomPacketPayload)new SSyncPlaceCountPacket(((KPlayer)player).kiwi$getPlaceCount()), (Player)player);
    }

    public static final class Handler
    implements PlayPacketHandler<SSyncPlaceCountPacket> {
        public static final StreamCodec<RegistryFriendlyByteBuf, SSyncPlaceCountPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SSyncPlaceCountPacket::placeCount, SSyncPlaceCountPacket::new);

        @Override
        public void handle(SSyncPlaceCountPacket packet, PayloadContext context) {
            context.execute(() -> Objects.requireNonNull((KPlayer)Minecraft.getInstance().player).kiwi$setPlaceCount(packet.placeCount));
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SSyncPlaceCountPacket> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

