/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PlayPacketHandler;

public final class KNetworking {
    private final IEventBus modEventBus;

    public KNetworking(IEventBus modEventBus) {
        this.modEventBus = modEventBus;
    }

    public <T extends CustomPacketPayload> void registerPlayHandler(CustomPacketPayload.Type<T> type, PlayPacketHandler<T> handler, KiwiPacket.Direction direction) {
        Preconditions.checkArgument((direction != KiwiPacket.Direction.AUTO ? 1 : 0) != 0, (Object)"Direction must be specified");
        this.modEventBus.addListener(event -> {
            PayloadRegistrar registrar = event.registrar(type.id().toString()).optional();
            if (direction == KiwiPacket.Direction.TO_CLIENT) {
                registrar.playToClient(type, handler.streamCodec(), (payload, context) -> handler.handle(payload, arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0)));
            } else if (direction == KiwiPacket.Direction.TO_SERVER) {
                registrar.playToServer(type, handler.streamCodec(), (payload, context) -> handler.handle(payload, () -> (ServerPlayer)context.player()));
            }
        });
    }

    public void processClass(KiwiAnnotationData annotationData) {
        try {
            Class<?> handlerClass;
            String packetClassName = annotationData.getTarget();
            if (Platform.isProduction() && packetClassName.startsWith("snownee.kiwi.test.")) {
                return;
            }
            Class<?> packetClass = Class.forName(packetClassName);
            Field field = packetClass.getDeclaredField("TYPE");
            CustomPacketPayload.Type type = (CustomPacketPayload.Type)field.get(null);
            KiwiPacket annotation = packetClass.getDeclaredAnnotation(KiwiPacket.class);
            KiwiPacket.Direction direction = annotation.dir();
            if (direction == KiwiPacket.Direction.AUTO) {
                String simpleName = packetClass.getSimpleName();
                char firstChar = simpleName.charAt(0);
                Preconditions.checkState((firstChar == 'C' || firstChar == 'S' ? 1 : 0) != 0, (String)"Packet class name must be '[CS][A-Z]', but got '%s'", (Object)simpleName);
                Preconditions.checkState((boolean)Character.isUpperCase(simpleName.charAt(1)), (String)"Packet class name must be '[CS][A-Z]', but got '%s'", (Object)simpleName);
                direction = firstChar == 'C' ? KiwiPacket.Direction.TO_SERVER : KiwiPacket.Direction.TO_CLIENT;
            }
            if (PlayPacketHandler.class.isAssignableFrom(handlerClass = Class.forName(packetClassName + "$Handler"))) {
                PlayPacketHandler handler = (PlayPacketHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                handler.register(this, type, direction);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

