/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.darkhax.tipsmod.common.api.TipsAPI;
import net.darkhax.tipsmod.common.api.tips.TipType;
import net.darkhax.tipsmod.common.impl.client.tips.SimpleTip;
import net.darkhax.tipsmod.common.impl.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TipsMod {
    public static final String MOD_ID = "tipsmod";
    public static final String MOD_NAME = "Tips";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Tips");
    public static final Component DEFAULT_TITLE = Component.translatable((String)"tipsmod.title.default").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE, ChatFormatting.YELLOW});
    public static final CachedSupplier<Config> CONFIG = CachedSupplier.cache(() -> (Config)ConfigManager.load((String)MOD_ID, (Object)new Config()));
    public static final TipType SIMPLE_TYPE = TipsAPI.registerType(SimpleTip.TYPE_ID, SimpleTip.CODEC);

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void init() {
        if (Services.PLATFORM.isPhysicalClient()) {
            TipsMod.registerDefaultScreens();
        }
    }

    private static void registerDefaultScreens() {
        TipsAPI.registerDefaultScreen(GenericMessageScreen.class);
        TipsAPI.registerDefaultScreen(ConnectScreen.class);
        TipsAPI.registerDefaultScreen(DisconnectedScreen.class);
        TipsAPI.registerDefaultScreen(LevelLoadingScreen.class);
        TipsAPI.registerDefaultScreen(ProgressScreen.class);
        TipsAPI.registerDefaultScreen(PauseScreen.class);
        TipsAPI.registerDefaultScreen(DeathScreen.class);
    }
}

