/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.golden_foods.mixin;

import forge.com.cursee.golden_foods.GoldenFoods;
import forge.com.cursee.golden_foods.core.registry.ModItemsForge;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FishingHook.class})
public abstract class ForgeFishingHookMixin {
    @Shadow
    @Nullable
    public abstract Player getPlayerOwner();

    @Redirect(method={"retrieve"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", ordinal=0))
    private boolean redirected$retrieveAddFreshEntity0(Level instance, Entity entity) {
        ItemEntity itemEntity;
        block7: {
            block6: {
                if (this.getPlayerOwner() == null || !(entity instanceof ItemEntity)) break block6;
                itemEntity = (ItemEntity)entity;
                if (!(instance.random.nextFloat() > 0.05f)) break block7;
            }
            return instance.addFreshEntity(entity);
        }
        Player player = this.getPlayerOwner();
        AtomicBoolean foundEnchantmentLeftHand = new AtomicBoolean(false);
        EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)player.getOffhandItem()).keySet().forEach(enchantmentHolder -> {
            if (enchantmentHolder.is(GoldenFoods.GOLDEN_FOODS)) {
                foundEnchantmentLeftHand.set(true);
            }
        });
        AtomicBoolean foundEnchantmentRightHand = new AtomicBoolean(false);
        EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)player.getMainHandItem()).keySet().forEach(enchantmentHolder -> {
            if (enchantmentHolder.is(GoldenFoods.GOLDEN_FOODS)) {
                foundEnchantmentRightHand.set(true);
            }
        });
        if (!foundEnchantmentRightHand.get() || !foundEnchantmentLeftHand.get()) {
            return instance.addFreshEntity(entity);
        }
        if (itemEntity.getItem().is(Items.COD)) {
            return instance.addFreshEntity((Entity)new ItemEntity(instance, player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)ModItemsForge.ENCHANTED_GOLDEN_COOKED_COD.get())));
        }
        if (itemEntity.getItem().is(Items.SALMON)) {
            return instance.addFreshEntity((Entity)new ItemEntity(instance, player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)ModItemsForge.ENCHANTED_GOLDEN_COOKED_SALMON.get())));
        }
        return instance.addFreshEntity(entity);
    }
}

