/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.medievalend.shared.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JigsawStructure.class})
public abstract class JigsawStructureMix {
    @Shadow
    @Final
    private Holder<StructureTemplatePool> startPool;

    @Inject(method={"findGenerationPoint"}, at={@At(value="RETURN")}, cancellable=true)
    private void getStructurePosition(Structure.GenerationContext context, CallbackInfoReturnable<Optional<Structure.GenerationStub>> cir) {
        String string = this.startPool.toString();
        if (string.contains("medievalend")) {
            Optional position = (Optional)cir.getReturnValue();
            if (position.isEmpty()) {
                return;
            }
            BlockPos pos = ((Structure.GenerationStub)position.get()).position();
            if (pos.getY() < 40) {
                cir.setReturnValue(Optional.empty());
                return;
            }
            if (string.contains("pyramid") || string.contains("castle")) {
                BlockPos centerAtY = context.chunkPos().getMiddleBlockPosition(0);
                for (int i = 1; i <= 2; ++i) {
                    for (Direction direction2 : Direction.values()) {
                        if (direction2 == Direction.DOWN) continue;
                        for (Direction direction1 : Direction.values()) {
                            int topY;
                            if (direction1 == Direction.DOWN || direction1 == direction2) continue;
                            NoiseColumn sample = context.chunkGenerator().getBaseColumn(centerAtY.getX() + i * 16 * (direction1.getNormal().getX() + direction2.getNormal().getX()), centerAtY.getZ() + i * 16 * (direction1.getNormal().getZ() + direction2.getNormal().getZ()), context.heightAccessor(), context.randomState());
                            for (topY = 75; topY > 0; --topY) {
                                BlockState state = sample.getBlock(topY);
                                if (state.isAir()) {
                                    continue;
                                }
                                if (!state.is(Blocks.WATER)) break;
                                cir.setReturnValue(Optional.empty());
                                return;
                            }
                            if (Math.abs(pos.getY() - topY) <= 5) continue;
                            cir.setReturnValue(Optional.empty());
                            return;
                        }
                    }
                }
            }
        }
    }
}

