/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.packet;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class PackedChunkLoaderAdded
implements BasePacket {
    private BlockPos pos;
    private UUID owner;
    private ChunkLoaderType type;

    public PackedChunkLoaderAdded(BlockPos pos, UUID owner, ChunkLoaderType type) {
        this.pos = pos;
        this.owner = owner;
        this.type = type;
    }

    public PackedChunkLoaderAdded() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUUID(this.owner);
        buffer.writeEnum((Enum)this.type);
    }

    public void read(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.owner = buffer.readUUID();
        this.type = (ChunkLoaderType)buffer.readEnum(ChunkLoaderType.class);
    }

    public boolean verify(PacketContext context) {
        return context.getHandlingSide() == CoreSide.CLIENT;
    }

    public void handle(PacketContext context) {
        ChunkLoadingCapability.get(context.getWorld()).castClient().addChunkLoader(this.pos, this.owner, this.type);
    }
}

