/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModSoundEvents;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Surrendered
extends Skeleton {
    protected static final EntityDataAccessor<Byte> DATA_VEX_FLAGS = SynchedEntityData.defineId(Surrendered.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final int CHARGING_FLAG = 1;
    @Nullable
    Mob owner;
    @Nullable
    private BlockPos bounds;
    private boolean alive;
    private int lifeTicks;

    public Surrendered(EntityType<? extends Surrendered> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new VexMoveControl(this);
    }

    public void move(MoverType movementType, Vec3 movement) {
        super.move(movementType, movement);
        this.checkInsideBlocks();
    }

    public void tick() {
        super.tick();
        this.setNoGravity(true);
        if (this.alive && --this.lifeTicks <= 0) {
            this.lifeTicks = 20;
            this.hurt(this.damageSources().starve(), 1.0f);
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new ChargeTargetGoal());
        this.goalSelector.addGoal(8, (Goal)new LookAtTargetGoal());
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new TrackOwnerTargetGoal((PathfinderMob)this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VEX_FLAGS, (Object)0);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("BoundX")) {
            this.bounds = new BlockPos(nbt.getInt("BoundX"), nbt.getInt("BoundY"), nbt.getInt("BoundZ"));
        }
        if (nbt.contains("LifeTicks")) {
            this.setLifeTicks(nbt.getInt("LifeTicks"));
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.bounds != null) {
            nbt.putInt("BoundX", this.bounds.getX());
            nbt.putInt("BoundY", this.bounds.getY());
            nbt.putInt("BoundZ", this.bounds.getZ());
        }
        if (this.alive) {
            nbt.putInt("LifeTicks", this.lifeTicks);
        }
    }

    @Nullable
    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    @Nullable
    public BlockPos getBounds() {
        return this.bounds;
    }

    public void setBounds(@Nullable BlockPos pos) {
        this.bounds = pos;
    }

    private boolean areFlagsSet(int mask) {
        byte i = (Byte)this.entityData.get(DATA_VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.entityData.get(DATA_VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.entityData.set(DATA_VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.areFlagsSet(1);
    }

    public void setCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    public void setLifeTicks(int lifeTicks) {
        this.alive = true;
        this.lifeTicks = lifeTicks;
    }

    public boolean doHurtTarget(Entity target) {
        if (!super.doHurtTarget(target)) {
            return false;
        }
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1), (Entity)this);
        }
        return true;
    }

    public void aiStep() {
        if (!this.level().isClientSide()) {
            for (int i = 0; i < 2; ++i) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.WHITE_ASH, this.xo, this.yo + 1.2, this.zo, 2, 0.2, 0.0, 0.2, 0.025);
            }
        }
        super.aiStep();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.SURRENDERED_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.SURRENDERED_DEATH_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSoundEvents.SURRENDERED_HURT_SOUND_EVENT.value();
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(level, level.getRandom(), difficulty);
        return super.finalizeSpawn(level, difficulty, spawnReason, entityData);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.AIR));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    class VexMoveControl
    extends MoveControl {
        public VexMoveControl(Surrendered owner) {
            super((Mob)owner);
        }

        public void tick() {
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                return;
            }
            Vec3 vec3d = new Vec3(this.wantedX - Surrendered.this.getX(), this.wantedY - Surrendered.this.getY(), this.wantedZ - Surrendered.this.getZ());
            double d = vec3d.length();
            if (d < Surrendered.this.getBoundingBox().getSize()) {
                this.operation = MoveControl.Operation.WAIT;
                Surrendered.this.setDeltaMovement(Surrendered.this.getDeltaMovement().scale(0.5));
            } else {
                Surrendered.this.setDeltaMovement(Surrendered.this.getDeltaMovement().add(vec3d.scale(this.speedModifier * 0.05 / d)));
                if (Surrendered.this.getTarget() == null) {
                    Vec3 vec3d2 = Surrendered.this.getDeltaMovement();
                    Surrendered.this.setYRot(-((float)Mth.atan2((double)vec3d2.x, (double)vec3d2.z)) * 57.295776f);
                    Surrendered.this.yBodyRot = Surrendered.this.getYRot();
                } else {
                    double e = Surrendered.this.getTarget().getX() - Surrendered.this.getX();
                    double f = Surrendered.this.getTarget().getZ() - Surrendered.this.getZ();
                    Surrendered.this.setYRot(-((float)Mth.atan2((double)e, (double)f)) * 57.295776f);
                    Surrendered.this.yBodyRot = Surrendered.this.getYRot();
                }
            }
        }
    }

    class ChargeTargetGoal
    extends Goal {
        public ChargeTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (Surrendered.this.getTarget() != null && !Surrendered.this.getMoveControl().hasWanted() && Surrendered.this.random.nextInt(ChargeTargetGoal.reducedTickDelay((int)7)) == 0) {
                return Surrendered.this.distanceToSqr((Entity)Surrendered.this.getTarget()) > 4.0;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return Surrendered.this.getMoveControl().hasWanted() && Surrendered.this.isCharging() && Surrendered.this.getTarget() != null && Surrendered.this.getTarget().isAlive();
        }

        public void start() {
            LivingEntity livingEntity = Surrendered.this.getTarget();
            if (livingEntity != null) {
                Vec3 vec3d = livingEntity.getEyePosition();
                Surrendered.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
            }
            Surrendered.this.setCharging(true);
            Surrendered.this.playSound((SoundEvent)ModSoundEvents.SURRENDERED_CHARGE_SOUND_EVENT.value(), 1.0f, 1.0f);
        }

        public void stop() {
            Surrendered.this.setCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingEntity = Surrendered.this.getTarget();
            if (livingEntity == null) {
                return;
            }
            if (Surrendered.this.getBoundingBox().intersects(livingEntity.getBoundingBox())) {
                Surrendered.this.doHurtTarget((Entity)livingEntity);
                Surrendered.this.setCharging(false);
            } else {
                double d = Surrendered.this.distanceToSqr((Entity)livingEntity);
                if (d < 9.0) {
                    Vec3 vec3d = livingEntity.getEyePosition();
                    Surrendered.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
                }
            }
        }
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !Surrendered.this.getMoveControl().hasWanted() && Surrendered.this.random.nextInt(LookAtTargetGoal.reducedTickDelay((int)7)) == 0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void tick() {
            BlockPos blockPos = Surrendered.this.getBounds();
            if (blockPos == null) {
                blockPos = Surrendered.this.blockPosition();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.offset(Surrendered.this.random.nextInt(15) - 7, Surrendered.this.random.nextInt(11) - 5, Surrendered.this.random.nextInt(15) - 7);
                if (!Surrendered.this.level().isEmptyBlock(blockPos2)) continue;
                Surrendered.this.moveControl.setWantedPosition((double)blockPos2.getX() + 0.5, (double)blockPos2.getY() + 0.5, (double)blockPos2.getZ() + 0.5, 0.25);
                if (Surrendered.this.getTarget() != null) break;
                Surrendered.this.getLookControl().setLookAt((double)blockPos2.getX() + 0.5, (double)blockPos2.getY() + 0.5, (double)blockPos2.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class TrackOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions targetPredicate;

        public TrackOwnerTargetGoal(PathfinderMob mob) {
            super((Mob)mob, false);
            this.targetPredicate = TargetingConditions.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            return Surrendered.this.owner != null && Surrendered.this.owner.getTarget() != null && this.canAttack(Surrendered.this.owner.getTarget(), this.targetPredicate);
        }

        public void start() {
            Surrendered.this.setTarget(Surrendered.this.owner.getTarget());
            super.start();
        }
    }
}

