/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slab;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCheckeredSlabSegmentGeometry
extends Geometry {
    private final boolean top;
    private final boolean second;

    public FramedCheckeredSlabSegmentGeometry(GeometryFactory.Context ctx) {
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.second = (Boolean)ctx.state().getValue((Property)PropertyHolder.SECOND);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            Direction xDir;
            boolean up = quadDir == Direction.UP;
            Direction direction = xDir = this.second ^ up ? Direction.WEST : Direction.EAST;
            if (up == this.top) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.SOUTH, 0.5f)).apply(Modifiers.cutTopBottom(xDir, 0.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.NORTH, 0.5f)).apply(Modifiers.cutTopBottom(xDir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.SOUTH, 0.5f)).apply(Modifiers.cutTopBottom(xDir.getOpposite(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.NORTH, 0.5f)).apply(Modifiers.cutTopBottom(xDir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        } else {
            Direction horDir;
            Direction direction = horDir = Utils.isX(quadDir) ^ this.second ? quadDir.getCounterClockWise() : quadDir.getClockWise();
            if (!this.top) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(horDir, 0.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(horDir.getOpposite(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(horDir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(horDir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        }
    }
}

